/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.Objects;

/**
 * Represents the implementation of subscriptionStatus.
 */
public final class SubscriptionStatus {

    private Class<? extends SubscriptionStreamStatus> identityref;

    /**
     * Creates an instance of subscriptionStatus.
     */
    private SubscriptionStatus() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public SubscriptionStatus(Class<? extends SubscriptionStreamStatus> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of subscriptionStatus for type identityref.
     *
     * @param value value of subscriptionStatus for type identityref
     * @return subscriptionStatus for type identityref
     */
    public static SubscriptionStatus of(Class<? extends SubscriptionStreamStatus> value) {
        return new SubscriptionStatus(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends SubscriptionStreamStatus> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends SubscriptionStreamStatus> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionStatus) {
            SubscriptionStatus other = (SubscriptionStatus) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(SubscriptionStreamStatus.class)) {
            return SubscriptionStreamStatus.subscriptionStreamStatusToString();
        } else if (identityref.equals(Active.class)) {
            return Active.activeToString();
        } else if (identityref.equals(Inactive.class)) {
            return Inactive.inactiveToString();
        } else if (identityref.equals(Suspended.class)) {
            return Suspended.suspendedToString();
        } else if (identityref.equals(InError.class)) {
            return InError.inErrorToString();
        }
        return null;
    }
    /**
     * Returns the object of subscriptionStatus fromString input String subscriptionStatus.
     *
     * @param valInString value of input String
     * @return subscriptionStatus
     */
    public static SubscriptionStatus fromString(String valInString) {
        try {
            Class<? extends SubscriptionStreamStatus> tmpVal = SubscriptionStreamStatus.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
