/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes;

import org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.tebandwidthtype.TeBandwidthTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of teBandwidthType.
 */
public final class TeBandwidthType {

    private TeBandwidthTypeEnum enumeration;

    /**
     * Creates an instance of teBandwidthType.
     */
    private TeBandwidthType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeBandwidthType(TeBandwidthTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teBandwidthType for type enumeration.
     *
     * @param value value of teBandwidthType for type enumeration
     * @return teBandwidthType for type enumeration
     */
    public static TeBandwidthType of(TeBandwidthTypeEnum value) {
        return new TeBandwidthType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeBandwidthTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeBandwidthTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeBandwidthType) {
            TeBandwidthType other = (TeBandwidthType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teBandwidthType fromString input String teBandwidthType.
     *
     * @param valInString value of input String
     * @return teBandwidthType
     */
    public static TeBandwidthType fromString(String valInString) {
        try {
            TeBandwidthTypeEnum tmpVal = TeBandwidthTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
