/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.admingroups;

import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.AdminGroup;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.ExtendedAdminGroup;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of adminGroupsUnion.
 */
public final class AdminGroupsUnion {
    private AdminGroup adminGroup;
    private ExtendedAdminGroup extendedAdminGroup;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of adminGroupsUnion.
     */
    private AdminGroupsUnion() {
    }

    /**
     * Creates an instance of adminGroup.
     *
     * @param adminGroup value of adminGroup
     */
    public AdminGroupsUnion(AdminGroup adminGroup) {
        setValue.set(0);
        this.adminGroup = adminGroup;
    }

    /**
     * Creates an instance of extendedAdminGroup.
     *
     * @param extendedAdminGroup value of extendedAdminGroup
     */
    public AdminGroupsUnion(ExtendedAdminGroup extendedAdminGroup) {
        setValue.set(1);
        this.extendedAdminGroup = extendedAdminGroup;
    }

    /**
     * Returns the object of adminGroupsUnion for type adminGroup.
     *
     * @param value value of adminGroupsUnion for type adminGroup
     * @return adminGroupsUnion for type adminGroup
     */
    public static AdminGroupsUnion of(AdminGroup value) {
        return new AdminGroupsUnion(value);
    }

    /**
     * Returns the object of adminGroupsUnion for type extendedAdminGroup.
     *
     * @param value value of adminGroupsUnion for type extendedAdminGroup
     * @return adminGroupsUnion for type extendedAdminGroup
     */
    public static AdminGroupsUnion of(ExtendedAdminGroup value) {
        return new AdminGroupsUnion(value);
    }

    /**
     * Returns the attribute adminGroup.
     *
     * @return adminGroup value of adminGroup
     */
    public AdminGroup adminGroup() {
        return adminGroup;
    }
    /**
     * Returns the attribute extendedAdminGroup.
     *
     * @return extendedAdminGroup value of extendedAdminGroup
     */
    public ExtendedAdminGroup extendedAdminGroup() {
        return extendedAdminGroup;
    }
    /**
     * Sets the attribute adminGroup.
     *
     * @param adminGroup value of adminGroup
     */
    public void adminGroup(AdminGroup adminGroup) {
        this.adminGroup = adminGroup;
    }
    /**
     * Sets the attribute extendedAdminGroup.
     *
     * @param extendedAdminGroup value of extendedAdminGroup
     */
    public void extendedAdminGroup(ExtendedAdminGroup extendedAdminGroup) {
        this.extendedAdminGroup = extendedAdminGroup;
    }

    @Override
    public int hashCode() {
        return Objects.hash(adminGroup, extendedAdminGroup);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AdminGroupsUnion) {
            AdminGroupsUnion other = (AdminGroupsUnion) obj;
            return
                Objects.deepEquals(adminGroup, other.adminGroup) &&
                Objects.deepEquals(extendedAdminGroup, other.extendedAdminGroup);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return adminGroup.toString();
        }
        if (setValue.get(1)) {
            return extendedAdminGroup.toString();
        }
        return null;
    }
    /**
     * Returns the object of adminGroupsUnion fromString input String adminGroupsUnion.
     *
     * @param valInString value of input String
     * @return adminGroupsUnion
     */
    public static AdminGroupsUnion fromString(String valInString) {
        try {
            AdminGroup tmpVal = AdminGroup.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            ExtendedAdminGroup tmpVal = ExtendedAdminGroup.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
