/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignal100Gbe.
 */
public abstract class ClientSignal100Gbe extends ClientSignal {

    /**
     * Returns the attribute client-signal-100GbE.
     *
     * @return client-signal-100GbE value of client-signal-100GbE
     */
    public static String clientSignal100GbeToString() {
        return "client-signal-100GbE";
    }

    /**
     * Returns the object of clientSignal100Gbe fromString input String clientSignal100Gbe.
     *
     * @param valInString value of input String
     * @return clientSignal100Gbe
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-100GbE")) {
            return ClientSignal100Gbe.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}