/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignal10GbEwan.
 */
public abstract class ClientSignal10GbEwan extends ClientSignal {

    /**
     * Returns the attribute client-signal-10GbE-WAN.
     *
     * @return client-signal-10GbE-WAN value of client-signal-10GbE-WAN
     */
    public static String clientSignal10GbEwanToString() {
        return "client-signal-10GbE-WAN";
    }

    /**
     * Returns the object of clientSignal10GbEwan fromString input String clientSignal10GbEwan.
     *
     * @param valInString value of input String
     * @return clientSignal10GbEwan
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-10GbE-WAN")) {
            return ClientSignal10GbEwan.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}