/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of tsg125g.
 */
public abstract class Tsg125g extends TributarySlotGranularity {

    /**
     * Returns the attribute tsg-1.25G.
     *
     * @return tsg-1.25G value of tsg-1.25G
     */
    public static String tsg125gToString() {
        return "tsg-1.25G";
    }

    /**
     * Returns the object of tsg125g fromString input String tsg125g.
     *
     * @param valInString value of input String
     * @return tsg125g
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tsg-1.25G")) {
            return Tsg125g.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}