/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbaugmentfromanotherfile.rev20160826.ytbaugmentfromanotherfile.networks.network.node.augmentedndnode.terminationpoint;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of supportingTerminationPoint.
 */
public interface SupportingTerminationPoint extends Augmentable  {

    /**
     * Identify the leaf of SupportingTerminationPoint.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents networkRef.
         */
        NETWORKREF(1),
        /**
         * Represents nodeRef.
         */
        NODEREF(2),
        /**
         * Represents tpRef.
         */
        TPREF(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    NetworkId networkRef();

    /**
     * Returns the attribute nodeRef.
     *
     * @return nodeRef value of nodeRef
     */
    NodeId nodeRef();

    /**
     * Returns the attribute tpRef.
     *
     * @return tpRef value of tpRef
     */
    String tpRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    void networkRef(NetworkId networkRef);

    /**
     * Sets the attribute nodeRef.
     *
     * @param nodeRef value of nodeRef
     */
    void nodeRef(NodeId nodeRef);

    /**
     * Sets the attribute tpRef.
     *
     * @param tpRef value of tpRef
     */
    void tpRef(String tpRef);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}