/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of ll7.
 */
public enum Ll7 {

    /**
     * Represents b1.
     */
    B1(0, "b1"),

    /**
     * Represents b2.
     */
    B2(1, "b2"),

    /**
     * Represents b3.
     */
    B3(2, "b3");

    private int ll7;
    private String schemaName;

    /**
     * Creates an instance of ll7.
     *
     * @param ll7 value of ll7
     */
     Ll7(int ll7, String schemaName) {
        this.ll7 = ll7;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of ll7 for.
     *
     * @param value value of ll7 for
     * @return ll7 for
     */
    public static Ll7 of(int value) {
        switch (value) {
            case 0:
                return Ll7.B1;
            case 1:
                return Ll7.B2;
            case 2:
                return Ll7.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of ll7 for.
     *
     * @param value value of ll7 for
     * @return ll7 for
     */
    public static Ll7 of(String value) {
        switch (value) {
            case "b1":
                return Ll7.B1;
            case "b2":
                return Ll7.B2;
            case "b3":
                return Ll7.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute ll7.
     *
     * @return ll7 value of ll7
     */
    public int ll7() {
        return ll7;
    }

    /**
     * Returns the object of ll7 fromString input String ll7.
     *
     * @param valInString value of input String
     * @return ll7
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Ll7 ll7 = of(bitName);
            if (ll7 != null) {
                tmpVal.set(ll7.ll7());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Ll7.B1.ll7())) {
            sBuild.append("b1");
            sBuild.append(" ");
        }
        if (bits.get(Ll7.B2.ll7())) {
            sBuild.append("b2");
            sBuild.append(" ");
        }
        if (bits.get(Ll7.B3.ll7())) {
            sBuild.append("b3");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
