/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules;

import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Xpath10;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of target.
 */
public class TargetKeys implements KeyInfo<DefaultTarget> {
    protected Xpath10 object;
    /**
     * Returns the attribute object.
     *
     * @return object value of object
     */
    public Xpath10 object() {
        return object;
    }

    /**
     * Sets the value to attribute object.
     *
     * @param object value of object
     */
    public void object(Xpath10 object) {
        this.object = object;
    }


    @Override
    public int hashCode() {
        return Objects.hash(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TargetKeys) {
            TargetKeys other = (TargetKeys) obj;
            return
                Objects.deepEquals(object, other.object);
        }
        return false;
    }
}