/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedules.schedules;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.scheduleconfigattributes.InclusiveExclusiveEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of schedule.
 */
public interface Schedule extends Augmentable  {

    /**
     * Identify the leaf of Schedule.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents scheduleId.
         */
        SCHEDULEID(1),
        /**
         * Represents inclusiveExclusive.
         */
        INCLUSIVEEXCLUSIVE(2),
        /**
         * Represents start.
         */
        START(3),
        /**
         * Represents scheduleDuration.
         */
        SCHEDULEDURATION(4),
        /**
         * Represents repeatInterval.
         */
        REPEATINTERVAL(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute scheduleId.
     *
     * @return scheduleId value of scheduleId
     */
    long scheduleId();

    /**
     * Returns the attribute inclusiveExclusive.
     *
     * @return inclusiveExclusive value of inclusiveExclusive
     */
    InclusiveExclusiveEnum inclusiveExclusive();

    /**
     * Returns the attribute start.
     *
     * @return start value of start
     */
    DateAndTime start();

    /**
     * Returns the attribute scheduleDuration.
     *
     * @return scheduleDuration value of scheduleDuration
     */
    String scheduleDuration();

    /**
     * Returns the attribute repeatInterval.
     *
     * @return repeatInterval value of repeatInterval
     */
    String repeatInterval();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute scheduleId.
     *
     * @param scheduleId value of scheduleId
     */
    void scheduleId(long scheduleId);

    /**
     * Sets the attribute inclusiveExclusive.
     *
     * @param inclusiveExclusive value of inclusiveExclusive
     */
    void inclusiveExclusive(InclusiveExclusiveEnum inclusiveExclusive);

    /**
     * Sets the attribute start.
     *
     * @param start value of start
     */
    void start(DateAndTime start);

    /**
     * Sets the attribute scheduleDuration.
     *
     * @param scheduleDuration value of scheduleDuration
     */
    void scheduleDuration(String scheduleDuration);

    /**
     * Sets the attribute repeatInterval.
     *
     * @param repeatInterval value of repeatInterval
     */
    void repeatInterval(String repeatInterval);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}