/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lspsstategrouping.lspsstate;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.LspProtectionRoleEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.LspResourceStatusEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsppropertiesstate.OriginTypeEnum;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lsprecordrouteinformationstate.LspRecordRouteSubobjects;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of lsp.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLsp extends InnerModelObject 
        implements Lsp, MultiInstanceObject<LspKeys> {
    protected IpAddress source;
    protected IpAddress destination;
    protected int tunnelId;
    protected int lspId;
    protected IpAddress extendedTunnelId;
    protected Class<? extends TunnelType> type;
    protected Class<? extends StateType> operStatus;
    protected Class<? extends TePathSetupProtocol> pathSetupProtocol;
    protected OriginTypeEnum originType;
    protected LspResourceStatusEnum lspResourceStatus;
    protected LspProtectionRoleEnum lspProtectionRole;
    protected boolean lspCarryNormalTraffic;
    protected BitSet valueLeafFlags = new BitSet();
    protected LspRecordRouteSubobjects lspRecordRouteSubobjects;

    @Override
    public IpAddress source() {
        return source;
    }

    @Override
    public IpAddress destination() {
        return destination;
    }

    @Override
    public int tunnelId() {
        return tunnelId;
    }

    @Override
    public int lspId() {
        return lspId;
    }

    @Override
    public IpAddress extendedTunnelId() {
        return extendedTunnelId;
    }

    @Override
    public Class<? extends TunnelType> type() {
        return type;
    }

    @Override
    public Class<? extends StateType> operStatus() {
        return operStatus;
    }

    @Override
    public Class<? extends TePathSetupProtocol> pathSetupProtocol() {
        return pathSetupProtocol;
    }

    @Override
    public OriginTypeEnum originType() {
        return originType;
    }

    @Override
    public LspResourceStatusEnum lspResourceStatus() {
        return lspResourceStatus;
    }

    @Override
    public LspProtectionRoleEnum lspProtectionRole() {
        return lspProtectionRole;
    }

    @Override
    public boolean lspCarryNormalTraffic() {
        return lspCarryNormalTraffic;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public LspRecordRouteSubobjects lspRecordRouteSubobjects() {
        return lspRecordRouteSubobjects;
    }

    @Override
    public void source(IpAddress source) {
        valueLeafFlags.set(LeafIdentifier.SOURCE.getLeafIndex());
        this.source = source;
    }

    @Override
    public void destination(IpAddress destination) {
        valueLeafFlags.set(LeafIdentifier.DESTINATION.getLeafIndex());
        this.destination = destination;
    }

    @Override
    public void tunnelId(int tunnelId) {
        valueLeafFlags.set(LeafIdentifier.TUNNELID.getLeafIndex());
        this.tunnelId = tunnelId;
    }

    @Override
    public void lspId(int lspId) {
        valueLeafFlags.set(LeafIdentifier.LSPID.getLeafIndex());
        this.lspId = lspId;
    }

    @Override
    public void extendedTunnelId(IpAddress extendedTunnelId) {
        valueLeafFlags.set(LeafIdentifier.EXTENDEDTUNNELID.getLeafIndex());
        this.extendedTunnelId = extendedTunnelId;
    }

    @Override
    public void type(Class<? extends TunnelType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void operStatus(Class<? extends StateType> operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol) {
        valueLeafFlags.set(LeafIdentifier.PATHSETUPPROTOCOL.getLeafIndex());
        this.pathSetupProtocol = pathSetupProtocol;
    }

    @Override
    public void originType(OriginTypeEnum originType) {
        valueLeafFlags.set(LeafIdentifier.ORIGINTYPE.getLeafIndex());
        this.originType = originType;
    }

    @Override
    public void lspResourceStatus(LspResourceStatusEnum lspResourceStatus) {
        valueLeafFlags.set(LeafIdentifier.LSPRESOURCESTATUS.getLeafIndex());
        this.lspResourceStatus = lspResourceStatus;
    }

    @Override
    public void lspProtectionRole(LspProtectionRoleEnum lspProtectionRole) {
        valueLeafFlags.set(LeafIdentifier.LSPPROTECTIONROLE.getLeafIndex());
        this.lspProtectionRole = lspProtectionRole;
    }

    @Override
    public void lspCarryNormalTraffic(boolean lspCarryNormalTraffic) {
        valueLeafFlags.set(LeafIdentifier.LSPCARRYNORMALTRAFFIC.getLeafIndex());
        this.lspCarryNormalTraffic = lspCarryNormalTraffic;
    }

    @Override
    public void lspRecordRouteSubobjects(LspRecordRouteSubobjects lspRecordRouteSubobjects) {
        this.lspRecordRouteSubobjects = lspRecordRouteSubobjects;
    }

    @Override
    public int hashCode() {
        return Objects.hash(source, destination, tunnelId, lspId, extendedTunnelId, type, operStatus, pathSetupProtocol, originType, lspResourceStatus, lspProtectionRole, lspCarryNormalTraffic, valueLeafFlags, lspRecordRouteSubobjects);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLsp) {
            DefaultLsp other = (DefaultLsp) obj;
            return
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(tunnelId, other.tunnelId) &&
                Objects.deepEquals(lspId, other.lspId) &&
                Objects.deepEquals(extendedTunnelId, other.extendedTunnelId) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(operStatus, other.operStatus) &&
                Objects.deepEquals(pathSetupProtocol, other.pathSetupProtocol) &&
                Objects.deepEquals(originType, other.originType) &&
                Objects.deepEquals(lspResourceStatus, other.lspResourceStatus) &&
                Objects.deepEquals(lspProtectionRole, other.lspProtectionRole) &&
                Objects.deepEquals(lspCarryNormalTraffic, other.lspCarryNormalTraffic) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(lspRecordRouteSubobjects, other.lspRecordRouteSubobjects);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("source=" + source)
            .add("destination=" + destination)
            .add("tunnelId=" + tunnelId)
            .add("lspId=" + lspId)
            .add("extendedTunnelId=" + extendedTunnelId)
            .add("type=" + type)
            .add("operStatus=" + operStatus)
            .add("pathSetupProtocol=" + pathSetupProtocol)
            .add("originType=" + originType)
            .add("lspResourceStatus=" + lspResourceStatus)
            .add("lspProtectionRole=" + lspProtectionRole)
            .add("lspCarryNormalTraffic=" + lspCarryNormalTraffic)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("lspRecordRouteSubobjects=" + lspRecordRouteSubobjects)
            .toString();
    }


    /**
     * Creates an instance of defaultLsp.
     */
    public DefaultLsp() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}