/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups.namedadmingroups.NamedAdminGroup;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of namedAdminGroups.
 */
public interface NamedAdminGroups extends Augmentable  {

    /**
     * Returns the attribute namedAdminGroup.
     *
     * @return namedAdminGroup list of namedAdminGroup
     */
    List<NamedAdminGroup> namedAdminGroup();

    /**
     * Sets the attribute namedAdminGroup.
     *
     * @param namedAdminGroup list of namedAdminGroup
     */
    void namedAdminGroup(List<NamedAdminGroup> namedAdminGroup);

    /**
     * Adds to the list of namedAdminGroup.
     *
     * @param addTo value of namedAdminGroup
     */
    void addToNamedAdminGroup(NamedAdminGroup addTo);

}