/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathaffinities.pathaffinities.style.named.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathaffinities.pathaffinities.style.named.constraints.constraint.AffinityNames;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of constraint.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConstraint extends InnerModelObject implements Constraint {
    protected List<AffinityNames> affinityNames;

    @Override
    public List<AffinityNames> affinityNames() {
        return affinityNames;
    }

    @Override
    public void affinityNames(List<AffinityNames> affinityNames) {
        this.affinityNames = affinityNames;
    }

    @Override
    public void addToAffinityNames(AffinityNames addTo) {
        if (affinityNames == null) {
            affinityNames = new ArrayList<>();
        }
        affinityNames.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(affinityNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConstraint) {
            DefaultConstraint other = (DefaultConstraint) obj;
            return
                Objects.deepEquals(affinityNames, other.affinityNames);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("affinityNames=" + affinityNames)
            .toString();
    }


    /**
     * Creates an instance of defaultConstraint.
     */
    public DefaultConstraint() {
    }

}