/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects.explicitrouteobjects;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.RouteUsageType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehop.Config;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehop.State;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of explicitRouteObject.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultExplicitRouteObject extends InnerModelObject 
        implements ExplicitRouteObject, MultiInstanceObject<ExplicitRouteObjectKeys> {
    protected Object index;
    protected Class<? extends RouteUsageType> explicitRouteUsage;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;

    @Override
    public Object index() {
        return index;
    }

    @Override
    public Class<? extends RouteUsageType> explicitRouteUsage() {
        return explicitRouteUsage;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public void index(Object index) {
        valueLeafFlags.set(LeafIdentifier.INDEX.getLeafIndex());
        this.index = index;
    }

    @Override
    public void explicitRouteUsage(Class<? extends RouteUsageType> explicitRouteUsage) {
        valueLeafFlags.set(LeafIdentifier.EXPLICITROUTEUSAGE.getLeafIndex());
        this.explicitRouteUsage = explicitRouteUsage;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(index, explicitRouteUsage, valueLeafFlags, config, state);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExplicitRouteObject) {
            DefaultExplicitRouteObject other = (DefaultExplicitRouteObject) obj;
            return
                Objects.deepEquals(index, other.index) &&
                Objects.deepEquals(explicitRouteUsage, other.explicitRouteUsage) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(config, other.config) &&
                Objects.deepEquals(state, other.state);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("index=" + index)
            .add("explicitRouteUsage=" + explicitRouteUsage)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("config=" + config)
            .add("state=" + state)
            .toString();
    }


    /**
     * Creates an instance of defaultExplicitRouteObject.
     */
    public DefaultExplicitRouteObject() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}