/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth;

import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Overflow;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.State;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Underflow;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of autoBandwidth.
 */
public interface AutoBandwidth extends Augmentable  {

    /**
     * Returns the attribute config.
     *
     * @return config value of config
     */
    Config config();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Returns the attribute overflow.
     *
     * @return overflow value of overflow
     */
    Overflow overflow();

    /**
     * Returns the attribute underflow.
     *
     * @return underflow value of underflow
     */
    Underflow underflow();

    /**
     * Sets the attribute config.
     *
     * @param config value of config
     */
    void config(Config config);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);

    /**
     * Sets the attribute overflow.
     *
     * @param overflow value of overflow
     */
    void overflow(Overflow overflow);

    /**
     * Sets the attribute underflow.
     *
     * @param underflow value of underflow
     */
    void underflow(Underflow underflow);

}