/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2mpproperties;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State extends Augmentable  {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents type.
         */
        TYPE(2),
        /**
         * Represents identifier.
         */
        IDENTIFIER(3),
        /**
         * Represents description.
         */
        DESCRIPTION(4),
        /**
         * Represents setupPriority.
         */
        SETUPPRIORITY(5),
        /**
         * Represents holdPriority.
         */
        HOLDPRIORITY(6),
        /**
         * Represents lspProtectionType.
         */
        LSPPROTECTIONTYPE(7),
        /**
         * Represents adminStatus.
         */
        ADMINSTATUS(8),
        /**
         * Represents reoptimizeTimer.
         */
        REOPTIMIZETIMER(9);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends TunnelType> type();

    /**
     * Returns the attribute identifier.
     *
     * @return identifier value of identifier
     */
    int identifier();

    /**
     * Returns the attribute description.
     *
     * @return description value of description
     */
    String description();

    /**
     * Returns the attribute setupPriority.
     *
     * @return setupPriority value of setupPriority
     */
    short setupPriority();

    /**
     * Returns the attribute holdPriority.
     *
     * @return holdPriority value of holdPriority
     */
    short holdPriority();

    /**
     * Returns the attribute lspProtectionType.
     *
     * @return lspProtectionType value of lspProtectionType
     */
    Class<? extends LspProtType> lspProtectionType();

    /**
     * Returns the attribute adminStatus.
     *
     * @return adminStatus value of adminStatus
     */
    Class<? extends StateType> adminStatus();

    /**
     * Returns the attribute reoptimizeTimer.
     *
     * @return reoptimizeTimer value of reoptimizeTimer
     */
    int reoptimizeTimer();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends TunnelType> type);

    /**
     * Sets the attribute identifier.
     *
     * @param identifier value of identifier
     */
    void identifier(int identifier);

    /**
     * Sets the attribute description.
     *
     * @param description value of description
     */
    void description(String description);

    /**
     * Sets the attribute setupPriority.
     *
     * @param setupPriority value of setupPriority
     */
    void setupPriority(short setupPriority);

    /**
     * Sets the attribute holdPriority.
     *
     * @param holdPriority value of holdPriority
     */
    void holdPriority(short holdPriority);

    /**
     * Sets the attribute lspProtectionType.
     *
     * @param lspProtectionType value of lspProtectionType
     */
    void lspProtectionType(Class<? extends LspProtType> lspProtectionType);

    /**
     * Sets the attribute adminStatus.
     *
     * @param adminStatus value of adminStatus
     */
    void adminStatus(Class<? extends StateType> adminStatus);

    /**
     * Sets the attribute reoptimizeTimer.
     *
     * @param reoptimizeTimer value of reoptimizeTimer
     */
    void reoptimizeTimer(int reoptimizeTimer);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}