/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsrpc.tunnelsrpcoutput.result;

/**
 * Represents ENUM data of resultEnum.
 */
public enum ResultEnum {

    /**
     * Represents success.
     */
    SUCCESS(0, "success"),

    /**
     * Represents in-progress.
     */
    IN_PROGRESS(1, "in-progress"),

    /**
     * Represents fail.
     */
    FAIL(2, "fail");

    private int resultEnum;
    private String schemaName;

    /**
     * Creates an instance of resultEnum.
     *
     * @param resultEnum value of resultEnum
     */
     ResultEnum(int resultEnum, String schemaName) {
        this.resultEnum = resultEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of resultEnum for.
     *
     * @param value value of resultEnum for
     * @return resultEnum for
     */
    public static ResultEnum of(int value) {
        switch (value) {
            case 0:
                return ResultEnum.SUCCESS;
            case 1:
                return ResultEnum.IN_PROGRESS;
            case 2:
                return ResultEnum.FAIL;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of resultEnum for.
     *
     * @param value value of resultEnum for
     * @return resultEnum for
     */
    public static ResultEnum of(String value) {
        switch (value) {
            case "success":
                return ResultEnum.SUCCESS;
            case "in-progress":
                return ResultEnum.IN_PROGRESS;
            case "fail":
                return ResultEnum.FAIL;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute resultEnum.
     *
     * @return resultEnum value of resultEnum
     */
    public int resultEnum() {
        return resultEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
