/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request;

import java.util.List;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.p2psecondarypaths.P2PsecondaryPath;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of p2PsecondaryPaths.
 */
public interface P2PsecondaryPaths extends Augmentable  {

    /**
     * Returns the attribute p2PsecondaryPath.
     *
     * @return p2PsecondaryPath list of p2PsecondaryPath
     */
    List<P2PsecondaryPath> p2PsecondaryPath();

    /**
     * Sets the attribute p2PsecondaryPath.
     *
     * @param p2PsecondaryPath list of p2PsecondaryPath
     */
    void p2PsecondaryPath(List<P2PsecondaryPath> p2PsecondaryPath);

    /**
     * Adds to the list of p2PsecondaryPath.
     *
     * @param addTo value of p2PsecondaryPath
     */
    void addToP2PsecondaryPath(P2PsecondaryPath addTo);

}