/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.p2psecondarypaths;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.p2ppathero.ExplicitRouteObjects;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of p2PsecondaryPath.
 */
public class DefaultP2PsecondaryPath extends InnerModelObject 
        implements P2PsecondaryPath, MultiInstanceObject<P2PsecondaryPathKeys> {
    protected String name;
    protected long teDefaultMetric;
    protected long teDelayMetric;
    protected long teHopMetric;
    protected BitSet valueLeafFlags = new BitSet();
    protected ExplicitRouteObjects explicitRouteObjects;

    @Override
    public String name() {
        return name;
    }

    @Override
    public long teDefaultMetric() {
        return teDefaultMetric;
    }

    @Override
    public long teDelayMetric() {
        return teDelayMetric;
    }

    @Override
    public long teHopMetric() {
        return teHopMetric;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ExplicitRouteObjects explicitRouteObjects() {
        return explicitRouteObjects;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void teDefaultMetric(long teDefaultMetric) {
        valueLeafFlags.set(LeafIdentifier.TEDEFAULTMETRIC.getLeafIndex());
        this.teDefaultMetric = teDefaultMetric;
    }

    @Override
    public void teDelayMetric(long teDelayMetric) {
        valueLeafFlags.set(LeafIdentifier.TEDELAYMETRIC.getLeafIndex());
        this.teDelayMetric = teDelayMetric;
    }

    @Override
    public void teHopMetric(long teHopMetric) {
        valueLeafFlags.set(LeafIdentifier.TEHOPMETRIC.getLeafIndex());
        this.teHopMetric = teHopMetric;
    }

    @Override
    public void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects) {
        this.explicitRouteObjects = explicitRouteObjects;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, teDefaultMetric, teDelayMetric, teHopMetric, valueLeafFlags, explicitRouteObjects);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultP2PsecondaryPath) {
            DefaultP2PsecondaryPath other = (DefaultP2PsecondaryPath) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(teDefaultMetric, other.teDefaultMetric) &&
                Objects.deepEquals(teDelayMetric, other.teDelayMetric) &&
                Objects.deepEquals(teHopMetric, other.teHopMetric) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(explicitRouteObjects, other.explicitRouteObjects);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("teDefaultMetric=" + teDefaultMetric)
            .add("teDelayMetric=" + teDelayMetric)
            .add("teHopMetric=" + teHopMetric)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("explicitRouteObjects=" + explicitRouteObjects)
            .toString();
    }


    /**
     * Creates an instance of defaultP2PsecondaryPath.
     */
    public DefaultP2PsecondaryPath() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}