/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint;

/**
 * Represents ENUM data of payloadTreatmentEnum.
 */
public enum PayloadTreatmentEnum {

    /**
     * Represents switching.
     */
    SWITCHING(0, "switching"),

    /**
     * Represents transport.
     */
    TRANSPORT(1, "transport");

    private int payloadTreatmentEnum;
    private String schemaName;

    /**
     * Creates an instance of payloadTreatmentEnum.
     *
     * @param payloadTreatmentEnum value of payloadTreatmentEnum
     */
     PayloadTreatmentEnum(int payloadTreatmentEnum, String schemaName) {
        this.payloadTreatmentEnum = payloadTreatmentEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of payloadTreatmentEnum for.
     *
     * @param value value of payloadTreatmentEnum for
     * @return payloadTreatmentEnum for
     */
    public static PayloadTreatmentEnum of(int value) {
        switch (value) {
            case 0:
                return PayloadTreatmentEnum.SWITCHING;
            case 1:
                return PayloadTreatmentEnum.TRANSPORT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of payloadTreatmentEnum for.
     *
     * @param value value of payloadTreatmentEnum for
     * @return payloadTreatmentEnum for
     */
    public static PayloadTreatmentEnum of(String value) {
        switch (value) {
            case "switching":
                return PayloadTreatmentEnum.SWITCHING;
            case "transport":
                return PayloadTreatmentEnum.TRANSPORT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute payloadTreatmentEnum.
     *
     * @return payloadTreatmentEnum value of payloadTreatmentEnum
     */
    public int payloadTreatmentEnum() {
        return payloadTreatmentEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
