/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.EditStatus;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.GlobalStatus;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yangPatchStatus.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYangPatchStatus extends InnerModelObject implements YangPatchStatus {
    protected String patchId;
    protected BitSet valueLeafFlags = new BitSet();
    protected GlobalStatus globalStatus;
    protected EditStatus editStatus;

    @Override
    public String patchId() {
        return patchId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public GlobalStatus globalStatus() {
        return globalStatus;
    }

    @Override
    public EditStatus editStatus() {
        return editStatus;
    }

    @Override
    public void patchId(String patchId) {
        valueLeafFlags.set(LeafIdentifier.PATCHID.getLeafIndex());
        this.patchId = patchId;
    }

    @Override
    public void globalStatus(GlobalStatus globalStatus) {
        this.globalStatus = globalStatus;
    }

    @Override
    public void editStatus(EditStatus editStatus) {
        this.editStatus = editStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(patchId, valueLeafFlags, globalStatus, editStatus);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangPatchStatus) {
            DefaultYangPatchStatus other = (DefaultYangPatchStatus) obj;
            return
                Objects.deepEquals(patchId, other.patchId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(globalStatus, other.globalStatus) &&
                Objects.deepEquals(editStatus, other.editStatus);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("patchId=" + patchId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("globalStatus=" + globalStatus)
            .add("editStatus=" + editStatus)
            .toString();
    }


    /**
     * Creates an instance of defaultYangPatchStatus.
     */
    public DefaultYangPatchStatus() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}