/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.EditStatus;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.GlobalStatus;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of yangPatchStatus.
 */
public interface YangPatchStatus extends Augmentable  {

    /**
     * Identify the leaf of YangPatchStatus.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents patchId.
         */
        PATCHID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute patchId.
     *
     * @return patchId value of patchId
     */
    String patchId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute globalStatus.
     *
     * @return globalStatus value of globalStatus
     */
    GlobalStatus globalStatus();

    /**
     * Returns the attribute editStatus.
     *
     * @return editStatus value of editStatus
     */
    EditStatus editStatus();

    /**
     * Sets the attribute patchId.
     *
     * @param patchId value of patchId
     */
    void patchId(String patchId);

    /**
     * Sets the attribute globalStatus.
     *
     * @param globalStatus value of globalStatus
     */
    void globalStatus(GlobalStatus globalStatus);

    /**
     * Sets the attribute editStatus.
     *
     * @param editStatus value of editStatus
     */
    void editStatus(EditStatus editStatus);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}