/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.editstatus;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.editstatus.edit.EditStatusChoice;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of edit.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultEdit extends InnerModelObject 
        implements Edit, MultiInstanceObject<EditKeys> {
    protected String editId;
    protected BitSet valueLeafFlags = new BitSet();
    protected EditStatusChoice editStatusChoice;

    @Override
    public String editId() {
        return editId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public EditStatusChoice editStatusChoice() {
        return editStatusChoice;
    }

    @Override
    public void editId(String editId) {
        valueLeafFlags.set(LeafIdentifier.EDITID.getLeafIndex());
        this.editId = editId;
    }

    @Override
    public void editStatusChoice(EditStatusChoice editStatusChoice) {
        this.editStatusChoice = editStatusChoice;
    }

    @Override
    public int hashCode() {
        return Objects.hash(editId, valueLeafFlags, editStatusChoice);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEdit) {
            DefaultEdit other = (DefaultEdit) obj;
            return
                Objects.deepEquals(editId, other.editId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(editStatusChoice, other.editStatusChoice);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("editId=" + editId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("editStatusChoice=" + editStatusChoice)
            .toString();
    }


    /**
     * Creates an instance of defaultEdit.
     */
    public DefaultEdit() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}