/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.subscriptionmodified;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Dscp;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatepolicy.UpdateTrigger;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedNotifBisSubscriptionModified.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedNotifBisSubscriptionModified extends InnerModelObject implements AugmentedNotifBisSubscriptionModified {
    protected Dscp dscp;
    protected short subscriptionPriority;
    protected String subscriptionDependency;
    protected BitSet valueLeafFlags = new BitSet();
    protected UpdateTrigger updateTrigger;

    @Override
    public Dscp dscp() {
        return dscp;
    }

    @Override
    public short subscriptionPriority() {
        return subscriptionPriority;
    }

    @Override
    public String subscriptionDependency() {
        return subscriptionDependency;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public UpdateTrigger updateTrigger() {
        return updateTrigger;
    }

    @Override
    public void dscp(Dscp dscp) {
        valueLeafFlags.set(LeafIdentifier.DSCP.getLeafIndex());
        this.dscp = dscp;
    }

    @Override
    public void subscriptionPriority(short subscriptionPriority) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONPRIORITY.getLeafIndex());
        this.subscriptionPriority = subscriptionPriority;
    }

    @Override
    public void subscriptionDependency(String subscriptionDependency) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONDEPENDENCY.getLeafIndex());
        this.subscriptionDependency = subscriptionDependency;
    }

    @Override
    public void updateTrigger(UpdateTrigger updateTrigger) {
        this.updateTrigger = updateTrigger;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dscp, subscriptionPriority, subscriptionDependency, valueLeafFlags, updateTrigger);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedNotifBisSubscriptionModified) {
            DefaultAugmentedNotifBisSubscriptionModified other = (DefaultAugmentedNotifBisSubscriptionModified) obj;
            return
                Objects.deepEquals(dscp, other.dscp) &&
                Objects.deepEquals(subscriptionPriority, other.subscriptionPriority) &&
                Objects.deepEquals(subscriptionDependency, other.subscriptionDependency) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(updateTrigger, other.updateTrigger);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("dscp=" + dscp)
            .add("subscriptionPriority=" + subscriptionPriority)
            .add("subscriptionDependency=" + subscriptionDependency)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("updateTrigger=" + updateTrigger)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedNotifBisSubscriptionModified.
     */
    public DefaultAugmentedNotifBisSubscriptionModified() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}