/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatefilter.updatefilter;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Xpath10;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatefilter.UpdateFilter;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of xpath.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultXpath extends InnerModelObject implements Xpath {
    protected Xpath10 xpathFilter;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Xpath10 xpathFilter() {
        return xpathFilter;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void xpathFilter(Xpath10 xpathFilter) {
        valueLeafFlags.set(LeafIdentifier.XPATHFILTER.getLeafIndex());
        this.xpathFilter = xpathFilter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(xpathFilter, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultXpath) {
            DefaultXpath other = (DefaultXpath) obj;
            return
                Objects.deepEquals(xpathFilter, other.xpathFilter) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("xpathFilter=" + xpathFilter)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultXpath.
     */
    public DefaultXpath() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}