/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangCommonInfo;
import org.onosproject.yang.compiler.datamodel.YangConfig;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangIfFeatureHolder;
import org.onosproject.yang.compiler.datamodel.YangIsFilterContentNodes;
import org.onosproject.yang.compiler.datamodel.YangMandatory;
import org.onosproject.yang.compiler.datamodel.YangMust;
import org.onosproject.yang.compiler.datamodel.YangMustHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangStatusType;
import org.onosproject.yang.compiler.datamodel.YangWhen;
import org.onosproject.yang.compiler.datamodel.YangWhenHolder;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;

public abstract class YangAnydata
extends YangNode
implements YangConfig,
YangIfFeatureHolder,
YangMandatory,
YangMustHolder,
YangWhenHolder,
YangCommonInfo,
Parsable,
CollisionDetector,
YangIsFilterContentNodes,
SingleInstanceNodeContext,
SchemaDataNode {
    private static final long serialVersionUID = -4962764560367658905L;
    private boolean isConfig;
    private String description;
    private List<YangIfFeature> ifFeatureList;
    private boolean isMandatory;
    private List<YangMust> mustConstraintList;
    private String reference;
    private YangStatusType status = YangStatusType.CURRENT;
    private YangWhen when;

    public YangAnydata() {
        super(YangNodeType.ANYDATA_NODE, new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>(), DataNode.Type.SINGLE_INSTANCE_NODE);
        this.mustConstraintList = new LinkedList<YangMust>();
        this.ifFeatureList = new LinkedList<YangIfFeature>();
    }

    @Override
    public void addToChildSchemaMap(YangSchemaNodeIdentifier schemaNodeIdentifier, YangSchemaNodeContextInfo yangSchemaNodeContextInfo) {
        this.getYsnContextInfoMap().put(schemaNodeIdentifier, yangSchemaNodeContextInfo);
    }

    @Override
    public void incrementMandatoryChildCount() {
    }

    @Override
    public void addToDefaultChildMap(YangSchemaNodeIdentifier yangSchemaNodeIdentifier, YangSchemaNode yangSchemaNode) {
    }

    @Override
    public YangSchemaNodeType getYangSchemaNodeType() {
        return YangSchemaNodeType.YANG_ANYDATA_NODE;
    }

    @Override
    public YangWhen getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(YangWhen when) {
        this.when = when;
    }

    @Override
    public boolean isConfig() {
        return this.isConfig;
    }

    @Override
    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public YangStatusType getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(YangStatusType status) {
        this.status = status;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.ANYDATA_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public void detectCollidingChild(String identifierName, YangConstructType dataType) throws DataModelException {
        DataModelUtils.detectCollidingChildUtil(identifierName, dataType, this);
    }

    @Override
    public void detectSelfCollision(String identifierName, YangConstructType dataType) throws DataModelException {
        if (this.getName().equals(identifierName)) {
            throw new DataModelException("YANG file error: Duplicate input identifier detected, same as container \"" + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public List<YangIfFeature> getIfFeatureList() {
        return this.ifFeatureList;
    }

    @Override
    public void addIfFeatureList(YangIfFeature ifFeature) {
        this.ifFeatureList.add(ifFeature);
    }

    @Override
    public void setIfFeatureList(List<YangIfFeature> ifFeatureList) {
        this.ifFeatureList = ifFeatureList;
    }

    @Override
    public List<YangMust> getListOfMust() {
        return this.mustConstraintList;
    }

    @Override
    public void setListOfMust(List<YangMust> mustConstraintList) {
        this.mustConstraintList = mustConstraintList;
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public void setMandatory(boolean isReq) {
        this.isMandatory = isReq;
    }

    @Override
    public void addMust(YangMust must) {
        this.mustConstraintList.add(must);
    }

    public SchemaContext getChildContext(SchemaId schemaId) {
        Preconditions.checkNotNull((Object)schemaId, (Object)"Schema id should not be null.");
        YangSchemaNodeIdentifier id = DataModelUtils.getNodeIdFromSchemaId(schemaId, this.getNameSpace().getModuleNamespace());
        try {
            YangSchemaNode node = this.getChildSchema(id).getSchemaNode();
            if (node instanceof SchemaDataNode) {
                return node;
            }
            throw new IllegalArgumentException(DataModelUtils.errorMsg("Requested %s is not child in %s.", schemaId.name(), this.getName()));
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public YangSchemaNode addSchema(YangSchemaNode containedSchema) throws IllegalArgumentException {
        YangNode nodeToClone = (YangNode)containedSchema;
        try {
            YangAnydata.cloneSubTree(nodeToClone.getParent(), this, null, false, nodeToClone);
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e);
        }
        YangNode child = this.getChild();
        String name = containedSchema.getName();
        while (child.getName() != name) {
            child = child.getNextSibling();
        }
        return child;
    }
}

