/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.SortedSet;
import org.onosproject.yang.compiler.datamodel.YangBits;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangEnum;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.model.LeafType;
import org.onosproject.yang.model.YangNamespace;

public final class LeafContextUtil {
    private static final String E_DATATYPE = "Data type not supported.";
    private static final String T = "true";
    private static final String F = "false";
    private static final String BIN_REGEX = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$";
    private static final String BREGEX = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$";

    private LeafContextUtil() {
    }

    public static Object getObject(YangType typeInfo, String v, YangDataTypes dataType) throws IllegalArgumentException {
        YangDataTypes type = dataType != null ? dataType : typeInfo.getDataType();
        switch (type) {
            case INT8: {
                return Byte.parseByte(v);
            }
            case UINT8: 
            case INT16: {
                return Short.parseShort(v);
            }
            case UINT16: 
            case INT32: {
                return Integer.parseInt(v);
            }
            case UINT32: 
            case INT64: {
                return Long.parseLong(v);
            }
            case UINT64: {
                return new BigInteger(v);
            }
            case EMPTY: {
                if (v == null || v.equals("")) {
                    return null;
                }
                if (v.equals(T) || v.equals(F)) {
                    return Boolean.parseBoolean(v);
                }
            }
            case BOOLEAN: {
                if (v.equals(T) || v.equals(F)) {
                    return Boolean.parseBoolean(v);
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case ENUMERATION: {
                try {
                    SortedSet<YangEnum> set = ((YangEnumeration)typeInfo.getDataTypeExtendedInfo()).getEnumSet();
                    for (YangEnum en : set) {
                        if (!en.getNamedValue().equals(v)) continue;
                        return v;
                    }
                }
                catch (Exception set) {
                    // empty catch block
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case BITS: {
                try {
                    YangBits e = (YangBits)typeInfo.getDataTypeExtendedInfo();
                    String[] bitSet = v.trim().split(" ");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(bitSet));
                    if (e.getBitNameMap().keySet().containsAll(set)) {
                        return v;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case BINARY: {
                if (v.matches(BREGEX)) {
                    return v;
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case IDENTITYREF: 
            case STRING: 
            case INSTANCE_IDENTIFIER: {
                return v;
            }
            case DECIMAL64: {
                return new BigDecimal(v);
            }
            case LEAFREF: {
                YangType refType = ((YangLeafRef)typeInfo.getDataTypeExtendedInfo()).getEffectiveDataType();
                return LeafContextUtil.getObject(refType, v, refType.getDataType());
            }
            case DERIVED: {
                YangType<?> rt = ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getReferredTypeDef().getTypeList().get(0);
                return LeafContextUtil.getObject(rt, v, rt.getDataType());
            }
            case UNION: {
                return LeafContextUtil.parseUnionTypeInfo(typeInfo, v);
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }

    public static YangNamespace getValueNamespace(YangType typeInfo, String v, YangDataTypes dataType) throws IllegalArgumentException {
        YangDataTypes type = dataType != null ? dataType : typeInfo.getDataType();
        switch (type) {
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case INT64: 
            case UINT64: 
            case EMPTY: 
            case BOOLEAN: 
            case ENUMERATION: 
            case BITS: 
            case BINARY: 
            case STRING: 
            case INSTANCE_IDENTIFIER: 
            case DECIMAL64: {
                return null;
            }
            case IDENTITYREF: {
                YangIdentity refId = ((YangIdentityRef)typeInfo.getDataTypeExtendedInfo()).getReferredIdentity();
                return LeafContextUtil.getReferIdNamespace(refId, v);
            }
            case LEAFREF: {
                YangType refType = ((YangLeafRef)typeInfo.getDataTypeExtendedInfo()).getEffectiveDataType();
                return LeafContextUtil.getValueNamespace(refType, v, refType.getDataType());
            }
            case DERIVED: {
                YangType<?> rt = ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getReferredTypeDef().getTypeList().get(0);
                return LeafContextUtil.getValueNamespace(rt, v, rt.getDataType());
            }
            case UNION: {
                return LeafContextUtil.getUnionValNamespace(typeInfo, v);
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }

    private static YangNamespace getReferIdNamespace(YangIdentity refId, String v) {
        String baseIdentity = refId.getYangSchemaNodeIdentifier().getName();
        if (v.equals(baseIdentity)) {
            return refId.getYangSchemaNodeIdentifier().getNameSpace();
        }
        for (YangIdentity i : refId.getExtendList()) {
            String refIdentity = i.getYangSchemaNodeIdentifier().getName();
            if (!v.equals(refIdentity)) continue;
            return i.getYangSchemaNodeIdentifier().getNameSpace();
        }
        throw new IllegalArgumentException("Invalid value of data");
    }

    private static YangNamespace getUnionValNamespace(YangType type, String leafValue) {
        ListIterator<YangType<?>> it = ((YangUnion)type.getDataTypeExtendedInfo()).getTypeList().listIterator();
        while (it.hasNext()) {
            YangType t = (YangType)it.next();
            try {
                LeafContextUtil.getObject(t, leafValue, t.getDataType());
                return LeafContextUtil.getValueNamespace(t, leafValue, t.getDataType());
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new IllegalArgumentException("Invalid value of data");
    }

    private static Object parseUnionTypeInfo(YangType type, String leafValue) {
        ListIterator<YangType<?>> it = ((YangUnion)type.getDataTypeExtendedInfo()).getTypeList().listIterator();
        while (it.hasNext()) {
            YangType t = (YangType)it.next();
            try {
                return LeafContextUtil.getObject(t, leafValue, t.getDataType());
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new IllegalArgumentException("Invalid value of data");
    }

    public static LeafType getLeafType(YangType typeInfo, String v, YangDataTypes dataType) throws IllegalArgumentException {
        YangDataTypes type = dataType != null ? dataType : typeInfo.getDataType();
        switch (type) {
            case INT8: {
                return LeafType.INT8;
            }
            case UINT8: {
                return LeafType.UINT8;
            }
            case INT16: {
                return LeafType.INT16;
            }
            case UINT16: {
                return LeafType.UINT16;
            }
            case INT32: {
                return LeafType.INT32;
            }
            case UINT32: {
                return LeafType.UINT32;
            }
            case INT64: {
                return LeafType.INT64;
            }
            case UINT64: {
                return LeafType.UINT64;
            }
            case EMPTY: {
                if (v == null || v.equals("") || v.equals(T) || v.equals(F)) {
                    return LeafType.EMPTY;
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case BOOLEAN: {
                if (v.equals(T) || v.equals(F)) {
                    return LeafType.BOOLEAN;
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case BINARY: {
                return LeafType.BINARY;
            }
            case BITS: {
                return LeafType.BITS;
            }
            case IDENTITYREF: {
                return LeafType.IDENTITYREF;
            }
            case ENUMERATION: {
                return LeafType.ENUMERATION;
            }
            case STRING: {
                return LeafType.STRING;
            }
            case INSTANCE_IDENTIFIER: {
                return LeafType.INSTANCE_IDENTIFIER;
            }
            case DECIMAL64: {
                return LeafType.DECIMAL64;
            }
            case LEAFREF: {
                YangType refType = ((YangLeafRef)typeInfo.getDataTypeExtendedInfo()).getEffectiveDataType();
                return LeafContextUtil.getLeafType(refType, v, refType.getDataType());
            }
            case DERIVED: {
                YangType<?> rt = ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getReferredTypeDef().getTypeList().get(0);
                return LeafContextUtil.getLeafType(rt, v, rt.getDataType());
            }
            case UNION: {
                return LeafContextUtil.parseUnionLeafType(typeInfo, v);
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }

    private static LeafType parseUnionLeafType(YangType type, String leafValue) {
        ListIterator<YangType<?>> it = ((YangUnion)type.getDataTypeExtendedInfo()).getTypeList().listIterator();
        while (it.hasNext()) {
            YangType t = (YangType)it.next();
            try {
                LeafContextUtil.getObject(t, leafValue, t.getDataType());
                return LeafContextUtil.getLeafType(t, leafValue, t.getDataType());
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new IllegalArgumentException("Invalid value of data");
    }
}

