/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.linker.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.LocationInfo;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangBase;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangImport;
import org.onosproject.yang.compiler.datamodel.YangInclude;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangPathPredicate;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangRelativePath;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.ResolvableStatus;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;
import org.onosproject.yang.model.YangNamespace;

public final class YangLinkerUtils {
    private static final int IDENTIFIER_LENGTH = 64;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");
    private static final String XML = "xml";
    private static final String INVALID_PATH_PRE = "YANG file error: The path predicate of the leafref has an invalid path in ";
    private static final String EMPTY_PATH_LIST_ERR = "YANG file error : The atomic path list cannot be empty of the leafref in the path ";
    private static final String TGT_LEAF_ERR = "YANG file error: There is no leaf/leaf-list in YANG node as mentioned in the path predicate of the leafref path ";
    private static final String LEAF_REF_LIST_ERR = "YANG file error: Path predicates are only applicable for YANG list. The leafref path has path predicate for non-list node in the path ";

    private YangLinkerUtils() {
    }

    private static void detectCollision(YangNode tgt, YangAugment aug, YangNode augRoot) {
        YangNode tgtRoot = YangLinkerUtils.getTgtRootNode(tgt);
        String augNs = ((YangNamespace)augRoot).getModuleNamespace();
        String tgtNs = ((YangNamespace)tgtRoot).getModuleNamespace();
        if (tgt instanceof YangChoice) {
            YangLinkerUtils.addCaseNodeToChoiceTarget(aug);
        }
        YangLinkerUtils.detectCollisionInTgt(tgt, aug, augNs, tgtNs);
    }

    private static void detectCollisionInTgt(YangNode tgt, YangAugment aug, String augNs, String tgtNs) {
        if (!augNs.equals(tgtNs)) {
            return;
        }
        YangNode aChild = aug.getChild();
        YangNode tChild = tgt.getChild();
        List<YangLeaf> aL = aug.getListOfLeaf();
        List<YangLeafList> aLl = aug.getListOfLeafList();
        List<YangLeaf> tL = null;
        List<YangLeafList> tLl = null;
        if (tgt instanceof YangLeavesHolder) {
            tL = ((YangLeavesHolder)((Object)tgt)).getListOfLeaf();
            tLl = ((YangLeavesHolder)((Object)tgt)).getListOfLeafList();
        }
        YangLinkerUtils.detectLeavesCollision(tL, tLl, aL, aLl);
        while (aChild != null) {
            YangLinkerUtils.detectNodeCollision(aChild, tChild, aL, aLl);
            YangLinkerUtils.detectLeafCollision(aChild.getName(), aChild, tL);
            YangLinkerUtils.detectLeafListCollision(aChild.getName(), aChild, tLl);
            aChild = aChild.getNextSibling();
        }
    }

    private static void detectLeavesCollision(List<YangLeaf> tL, List<YangLeafList> tLl, List<YangLeaf> aL, List<YangLeafList> aLl) {
        if (aL != null && !aL.isEmpty()) {
            for (YangLeaf aLeaf : aL) {
                YangLinkerUtils.detectLeafCollision(aLeaf.getName(), aLeaf, tL);
                YangLinkerUtils.detectLeafListCollision(aLeaf.getName(), aLeaf, tLl);
            }
        }
        if (aLl != null && !aLl.isEmpty()) {
            for (YangLeafList aLeafList : aLl) {
                YangLinkerUtils.detectLeafCollision(aLeafList.getName(), aLeafList, tL);
                YangLinkerUtils.detectLeafListCollision(aLeafList.getName(), aLeafList, tLl);
            }
        }
    }

    private static void detectLeafListCollision(String name, LocationInfo info, List<YangLeafList> leavesList) {
        if (leavesList != null && !leavesList.isEmpty()) {
            for (YangLeafList ll : leavesList) {
                YangLinkerUtils.detectCollision(ll.getName(), name, info, " target node leaf/leaf-list");
            }
        }
    }

    private static void detectLeafCollision(String name, LocationInfo info, List<YangLeaf> leaves) {
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                YangLinkerUtils.detectCollision(leaf.getName(), name, info, " target node leaf/leaf-list");
            }
        }
    }

    private static void detectNodeCollision(YangNode aug, YangNode tgt, List<YangLeaf> aL, List<YangLeafList> aLl) {
        while (tgt != null) {
            YangLinkerUtils.detectCollision(tgt.getName(), aug.getName(), aug, " target node ");
            YangLinkerUtils.detectLeafCollision(tgt.getName(), tgt, aL);
            YangLinkerUtils.detectLeafListCollision(tgt.getName(), tgt, aLl);
            tgt = tgt.getNextSibling();
        }
    }

    private static YangNode getTgtRootNode(YangNode node) {
        YangNode root = node;
        while (!(root instanceof YangReferenceResolver)) {
            if ((root = root.getParent()) != null) continue;
            throw new LinkerException("Datamodel tree is not correct");
        }
        return root;
    }

    private static void detectCollision(String first, String second, LocationInfo info, String type) {
        if (first.equals(second)) {
            throw new LinkerException(ErrorMessages.getErrorMsgCollision("YANG File Error: Identifier collision detected in", second, info.getLineNumber(), info.getCharPosition(), type, info.getFileName()));
        }
    }

    private static void addCaseNodeToChoiceTarget(YangAugment augment) {
        try {
            YangCase javaCase;
            LinkedHashMap<YangNode, List<YangNode>> map;
            ArrayList<YangNode> childNodes = new ArrayList<YangNode>();
            ArrayList<YangNode> caseNodes = new ArrayList<YangNode>();
            for (YangNode child = augment.getChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof YangCase)) {
                    childNodes.add(child);
                    continue;
                }
                caseNodes.add(child);
            }
            augment.setChild(null);
            for (YangNode node : childNodes) {
                map = new LinkedHashMap<YangNode, List<YangNode>>();
                node.setNextSibling(null);
                node.setPreviousSibling(null);
                node.setParent(null);
                YangCase javaCase2 = YangDataModelFactory.getYangCaseNode(GeneratedLanguage.JAVA_GENERATION);
                javaCase2.setName(node.getName());
                YangLinkerUtils.traverseAndBreak(node, map);
                augment.addChild(javaCase2);
                node.setParent(javaCase2);
                javaCase2.addChild(node);
                YangLinkerUtils.connectTree(map);
            }
            for (YangNode node : caseNodes) {
                map = new LinkedHashMap();
                node.setNextSibling(null);
                node.setPreviousSibling(null);
                node.setParent(null);
                YangLinkerUtils.traverseAndBreak(node, map);
                augment.addChild(node);
                node.setParent(augment);
                YangLinkerUtils.connectTree(map);
            }
            if (augment.getListOfLeaf() != null) {
                for (YangLeaf leaf : augment.getListOfLeaf()) {
                    javaCase = YangDataModelFactory.getYangCaseNode(GeneratedLanguage.JAVA_GENERATION);
                    javaCase.setName(leaf.getName());
                    javaCase.addLeaf(leaf);
                    augment.addChild(javaCase);
                }
                augment.getListOfLeaf().clear();
            }
            if (augment.getListOfLeafList() != null) {
                for (YangLeafList leafList : augment.getListOfLeafList()) {
                    javaCase = YangDataModelFactory.getYangCaseNode(GeneratedLanguage.JAVA_GENERATION);
                    javaCase.setName(leafList.getName());
                    javaCase.addLeafList(leafList);
                    augment.addChild(javaCase);
                }
                augment.getListOfLeafList().clear();
            }
        }
        catch (DataModelException e) {
            throw new TranslatorException(ErrorMessages.getErrorMsg("Failed to add child nodes to case node of augment ", augment.getName(), augment.getLineNumber(), augment.getCharPosition(), augment.getFileName()));
        }
    }

    private static void connectTree(Map<YangNode, List<YangNode>> map) throws DataModelException {
        ArrayList<YangNode> keys = new ArrayList<YangNode>(map.keySet());
        int size = keys.size();
        for (int i = size - 1; i >= 0; --i) {
            YangNode curNode = keys.get(i);
            List<YangNode> nodes = map.get(curNode);
            if (nodes == null) continue;
            for (YangNode node : nodes) {
                curNode.addChild(node);
            }
        }
        map.clear();
    }

    private static void processHierarchyChild(YangNode node, Map<YangNode, List<YangNode>> map) {
        YangNode child = node.getChild();
        if (child != null) {
            ArrayList<YangNode> nodes = new ArrayList<YangNode>();
            while (child != null) {
                nodes.add(child);
                child.setParent(null);
                if ((child = child.getNextSibling()) == null) continue;
                child.getPreviousSibling().setNextSibling(null);
                child.setPreviousSibling(null);
            }
            map.put(node, nodes);
        }
        node.setChild(null);
    }

    private static void traverseAndBreak(YangNode rootNode, Map<YangNode, List<YangNode>> map) {
        YangNode curNode = rootNode;
        TraversalType curTraversal = TraversalType.ROOT;
        while (curNode != null) {
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            if ((curNode = curNode.getParent()) == null) continue;
            YangLinkerUtils.processHierarchyChild(curNode, map);
        }
    }

    static String getErrorInfoForLinker(Object resolvable) {
        if (resolvable instanceof YangType) {
            return "YANG file error: Unable to find base typedef for given type";
        }
        if (resolvable instanceof YangUses) {
            return "YANG file error: Unable to find base grouping for given uses";
        }
        if (resolvable instanceof YangIfFeature) {
            return "YANG file error: Unable to find feature for given if-feature";
        }
        if (resolvable instanceof YangBase) {
            return "YANG file error: Unable to find base identity for given base";
        }
        if (resolvable instanceof YangIdentityRef) {
            return "YANG file error: Unable to find base identity for given base";
        }
        return "YANG file error: Unable to find base leaf/leaf-list for given leafref";
    }

    static String getLeafRefErrorInfo(YangLeafRef leafref) {
        return ErrorMessages.getErrorMsg("YANG file error: The target node, in the leafref path " + leafref.getPath() + "," + " is invalid.", "", leafref.getLineNumber(), leafref.getCharPosition(), leafref.getFileName());
    }

    static void detectCollisionForAugment(YangNode tgt, YangAugment aug, YangNode augRoot) {
        YangLinkerUtils.detectCollision(tgt, aug, augRoot);
        List<YangAugment> infoList = ((YangAugmentableNode)((Object)tgt)).getAugmentedInfoList();
        for (YangAugment info : infoList) {
            YangLinkerUtils.detectCollision(info, aug, augRoot);
        }
    }

    static Object getPathWithAugment(YangAugment augment, int remainingAncestors) {
        ArrayList<String> listOfPathName = new ArrayList<String>();
        YangNode node = augment.getAugmentedNode();
        for (YangAtomicPath atomicPath : augment.getTargetNode()) {
            if (atomicPath.getNodeIdentifier().getPrefix() != null && !atomicPath.getNodeIdentifier().getPrefix().equals("")) {
                listOfPathName.add(atomicPath.getNodeIdentifier().getPrefix() + ":" + atomicPath.getNodeIdentifier().getName());
            } else {
                listOfPathName.add(atomicPath.getNodeIdentifier().getName());
            }
            if (node == null) continue;
            node = node.getParent();
        }
        for (int countOfAncestor = 0; countOfAncestor < remainingAncestors; ++countOfAncestor) {
            if (listOfPathName.isEmpty()) {
                return YangLinkerUtils.getNodeFromUsesAug(node, remainingAncestors - countOfAncestor);
            }
            listOfPathName.remove(listOfPathName.size() - 1);
        }
        if (listOfPathName.isEmpty()) {
            return YangLinkerUtils.getNodeFromUsesAug(node, 0);
        }
        return listOfPathName;
    }

    private static YangNode getNodeFromUsesAug(YangNode node, int count) {
        for (int val = 0; val < count; ++val) {
            node = node.getParent();
        }
        return node;
    }

    public static YangNode skipInvalidDataNodes(YangNode curParent, YangLeafRef leafRef) throws LinkerException {
        YangNode node = curParent;
        while (node instanceof YangChoice || node instanceof YangCase) {
            if (node.getParent() == null) {
                throw new LinkerException(YangLinkerUtils.getLeafRefErrorInfo(leafRef));
            }
            node = node.getParent();
        }
        return node;
    }

    static YangNodeIdentifier getValidNodeIdentifier(String nodeIdentifierString, YangConstructType yangConstruct) {
        String[] tmpData = nodeIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(YangLinkerUtils.getValidIdentifier(tmpData[0], yangConstruct));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(YangLinkerUtils.getValidIdentifier(tmpData[0], yangConstruct));
            nodeIdentifier.setName(YangLinkerUtils.getValidIdentifier(tmpData[1], yangConstruct));
            return nodeIdentifier;
        }
        throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + nodeIdentifierString + " is not valid.");
    }

    public static String getValidIdentifier(String identifier, YangConstructType yangConstruct) {
        if (identifier.length() > 64) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifier + " is greater than 64 characters.");
        }
        if (!IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " name " + identifier + " is not valid.");
        }
        if (identifier.toLowerCase().startsWith(XML)) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType(yangConstruct) + " identifier " + identifier + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        }
        return identifier;
    }

    public static void updateFilePriority(Set<YangNode> yangNodeSet) {
        for (YangNode yangNode : yangNodeSet) {
            YangLinkerUtils.updateFilePriorityOfNode(yangNode);
        }
    }

    private static void updateFilePriorityOfNode(YangNode yangNode) {
        int curNodePriority = yangNode.getPriority();
        if (yangNode instanceof YangReferenceResolver) {
            List<YangImport> yangImportList = ((YangReferenceResolver)((Object)yangNode)).getImportList();
            for (YangImport yangImport : yangImportList) {
                YangNode importedNode = yangImport.getImportedNode();
                if (curNodePriority < importedNode.getPriority()) continue;
                importedNode.setPriority(curNodePriority + 1);
                YangLinkerUtils.updateFilePriorityOfNode(importedNode);
            }
            List<YangInclude> yangIncludeList = ((YangReferenceResolver)((Object)yangNode)).getIncludeList();
            for (YangInclude yangInclude : yangIncludeList) {
                YangNode includedNode = yangInclude.getIncludedNode();
                if (curNodePriority < includedNode.getPriority()) continue;
                includedNode.setPriority(curNodePriority + 1);
                YangLinkerUtils.updateFilePriorityOfNode(includedNode);
            }
        }
    }

    public static void resolveGroupingInDefinationScope(YangReferenceResolver referenceResolver) {
        for (YangNode potentialInterFileGrouping = ((YangNode)((Object)referenceResolver)).getChild(); potentialInterFileGrouping != null; potentialInterFileGrouping = potentialInterFileGrouping.getNextSibling()) {
            if (!(potentialInterFileGrouping instanceof YangGrouping)) continue;
            YangLinkerUtils.addGroupingResolvableEntitiesToResolutionList((YangGrouping)potentialInterFileGrouping);
        }
    }

    private static void addGroupingResolvableEntitiesToResolutionList(YangGrouping interFileGrouping) {
        YangNode curNode = interFileGrouping;
        TraversalType curTraversal = TraversalType.ROOT;
        YangLinkerUtils.addResolvableLeavesToResolutionList((YangLeavesHolder)((Object)curNode));
        curTraversal = TraversalType.CHILD;
        curNode = interFileGrouping.getChild();
        if (curNode == null) {
            return;
        }
        while (curNode != interFileGrouping) {
            if (curTraversal != TraversalType.PARENT) {
                YangType<?> type;
                List<YangType<?>> typeList;
                if (curNode instanceof YangGrouping || curNode instanceof YangUses) {
                    if (curNode.getNextSibling() != null) {
                        curTraversal = TraversalType.SIBLING;
                        curNode = curNode.getNextSibling();
                        continue;
                    }
                    curTraversal = TraversalType.PARENT;
                    curNode = curNode.getParent();
                    continue;
                }
                if (curNode instanceof YangLeavesHolder) {
                    YangLinkerUtils.addResolvableLeavesToResolutionList((YangLeavesHolder)((Object)curNode));
                } else if (curNode instanceof YangTypeDef && !(typeList = ((YangTypeDef)curNode).getTypeList()).isEmpty() && (type = typeList.get(0)).getDataType() == YangDataTypes.DERIVED && type.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    YangResolutionInfoImpl resolutionInfo = new YangResolutionInfoImpl(type, curNode, type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo);
                    }
                    catch (DataModelException e) {
                        String errorInfo = "Error in file: " + curNode.getName() + " in " + curNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + e.getLocalizedMessage();
                        throw new LinkerException("Failed to add type info in grouping to resolution " + errorInfo);
                    }
                }
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
    }

    private static void addResolvableLeavesToResolutionList(YangLeavesHolder leavesHolder) {
        YangResolutionInfoImpl<YangIdentityRef> resolutionInfo;
        YangIdentityRef identityRef;
        YangResolutionInfoImpl resolutionInfo2;
        YangType<?> type;
        if (leavesHolder.getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty()) {
            for (YangLeaf leaf : leavesHolder.getListOfLeaf()) {
                type = leaf.getDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    resolutionInfo2 = new YangResolutionInfoImpl(type, (YangNode)((Object)leavesHolder), type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo2);
                        continue;
                    }
                    catch (DataModelException e) {
                        throw new LinkerException("Failed to add leaf type info in grouping, to resolution ");
                    }
                }
                if (type.getDataType() != YangDataTypes.IDENTITYREF) continue;
                identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
                identityRef.setIdentityForInterFileGroupingResolution(true);
                resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)((Object)leavesHolder), identityRef.getLineNumber(), identityRef.getCharPosition());
                try {
                    DataModelUtils.addResolutionInfo(resolutionInfo);
                }
                catch (DataModelException e) {
                    throw new LinkerException("Failed to add leaf identity ref info in grouping, to resolution ");
                }
            }
        }
        if (leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty()) {
            for (YangLeafList leafList : leavesHolder.getListOfLeafList()) {
                type = leafList.getDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    resolutionInfo2 = new YangResolutionInfoImpl(type, (YangNode)((Object)leavesHolder), type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo2);
                        continue;
                    }
                    catch (DataModelException e) {
                        throw new LinkerException("Failed to add leaf type info in grouping, to resolution ");
                    }
                }
                if (type.getDataType() != YangDataTypes.IDENTITYREF) continue;
                identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
                identityRef.setIdentityForInterFileGroupingResolution(true);
                resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)((Object)leavesHolder), identityRef.getLineNumber(), identityRef.getCharPosition());
                try {
                    DataModelUtils.addResolutionInfo(resolutionInfo);
                }
                catch (DataModelException e) {
                    throw new LinkerException("Failed to add leaf identity ref info in grouping, to resolution ");
                }
            }
        }
    }

    public static void fillPathPredicates(YangLeafRef<?> leafRef) throws DataModelException {
        List<YangAtomicPath> atomics = leafRef.getAtomicPath();
        if (atomics != null) {
            for (YangAtomicPath atom : atomics) {
                List<YangPathPredicate> predicates = atom.getPathPredicatesList();
                if (predicates == null) continue;
                for (YangPathPredicate predicate : predicates) {
                    YangLinkerUtils.setLeftAxisNode(leafRef, atom, predicate);
                    YangLinkerUtils.setRightAxisNode(leafRef, predicate);
                }
            }
        }
    }

    private static void setLeftAxisNode(YangLeafRef<?> leafRef, YangAtomicPath atom, YangPathPredicate predicate) throws DataModelException {
        YangNode resolvedNode = atom.getResolvedNode();
        if (!(resolvedNode instanceof YangList)) {
            throw YangLinkerUtils.getDataModelExc(LEAF_REF_LIST_ERR, leafRef);
        }
        YangNodeIdentifier leftAxisName = predicate.getNodeId();
        Object target = YangLinkerUtils.getTarget(leftAxisName, resolvedNode, leafRef);
        predicate.setLeftAxisNode(target);
    }

    private static Object getTarget(YangNodeIdentifier leftAxisName, YangNode node, YangLeafRef leafRef) throws DataModelException {
        YangLeaf leaf = YangLinkerUtils.getLeaf(leftAxisName, (YangLeavesHolder)((Object)node));
        YangLeafList leafList = YangLinkerUtils.getLeafList(leftAxisName, (YangLeavesHolder)((Object)node));
        if (leaf == null && leafList == null && node instanceof YangAugmentableNode) {
            List<YangAugment> augList = ((YangAugmentableNode)((Object)node)).getAugmentedInfoList();
            for (YangAugment aug : augList) {
                leaf = YangLinkerUtils.getLeaf(leftAxisName, aug);
                leafList = YangLinkerUtils.getLeafList(leftAxisName, aug);
                if (leaf == null && leafList == null) continue;
                break;
            }
        }
        if (leaf == null && leafList == null) {
            throw YangLinkerUtils.getDataModelExc(TGT_LEAF_ERR, leafRef);
        }
        return leaf != null ? leaf : leafList;
    }

    private static YangLeaf getLeaf(YangNodeIdentifier name, YangLeavesHolder holder) {
        List<YangLeaf> listOfLeaf = holder.getListOfLeaf();
        if (listOfLeaf != null) {
            for (YangLeaf yangLeaf : listOfLeaf) {
                if (!yangLeaf.getName().equals(name.getName())) continue;
                return yangLeaf;
            }
        }
        return null;
    }

    private static YangLeafList getLeafList(YangNodeIdentifier name, YangLeavesHolder holder) {
        List<YangLeafList> listOfLeafList = holder.getListOfLeafList();
        if (listOfLeafList != null) {
            for (YangLeafList yangLeafList : listOfLeafList) {
                if (!yangLeafList.getName().equals(name.getName())) continue;
                return yangLeafList;
            }
        }
        return null;
    }

    private static YangNode getRootNode(int count, YangNode node, YangLeafRef leafRef) throws DataModelException {
        YangNode curParent = node;
        int curCount = 0;
        while (curCount < count) {
            if (++curCount != 1) {
                if (curParent.getParent() == null) {
                    throw YangLinkerUtils.getDataModelExc("Internal datamodel error: Datamodel tree is not correct", leafRef);
                }
                curParent = curParent.getParent();
            }
            if (!((curParent = YangLinkerUtils.skipInvalidDataNodes(curParent, leafRef)) instanceof YangAugment)) continue;
            YangAugment augment = (YangAugment)curParent;
            curParent = augment.getAugmentedNode();
            ++curCount;
        }
        return curParent;
    }

    private static Object getLastNode(YangNode curNode, YangRelativePath relPath, YangLeafRef leafRef) throws DataModelException {
        YangNode node = curNode;
        ArrayList<YangAtomicPath> atomics = new ArrayList<YangAtomicPath>();
        atomics.addAll(relPath.getAtomicPathList());
        if (atomics.isEmpty()) {
            throw YangLinkerUtils.getDataModelExc(EMPTY_PATH_LIST_ERR, leafRef);
        }
        YangAtomicPath pathTgt = (YangAtomicPath)atomics.get(atomics.size() - 1);
        if (atomics.size() == 1) {
            return YangLinkerUtils.getTarget(pathTgt.getNodeIdentifier(), node, leafRef);
        }
        atomics.remove(atomics.size() - 1);
        for (YangAtomicPath atomicPath : atomics) {
            if ((node = YangLinkerUtils.getNode(node.getChild(), atomicPath.getNodeIdentifier())) != null) continue;
            throw YangLinkerUtils.getDataModelExc(INVALID_PATH_PRE, leafRef);
        }
        return YangLinkerUtils.getTarget(pathTgt.getNodeIdentifier(), node, leafRef);
    }

    private static YangNode getNode(YangNode curNode, YangNodeIdentifier identifier) {
        for (YangNode node = curNode; node != null; node = node.getNextSibling()) {
            if (!node.getName().equals(identifier.getName())) continue;
            return node;
        }
        return null;
    }

    private static void setRightAxisNode(YangLeafRef leafRef, YangPathPredicate predicate) throws DataModelException {
        YangNode parentNode = leafRef.getParentNode();
        YangRelativePath relPath = predicate.getRelPath();
        int ancestor = relPath.getAncestorNodeCount();
        YangNode rootNode = YangLinkerUtils.getRootNode(ancestor, parentNode, leafRef);
        Object target = YangLinkerUtils.getLastNode(rootNode, relPath, leafRef);
        if (target == null) {
            throw YangLinkerUtils.getDataModelExc(INVALID_PATH_PRE, leafRef);
        }
        predicate.setRightAxisNode(target);
    }

    private static DataModelException getDataModelExc(String msg, YangLeafRef leafRef) {
        DataModelException exc = new DataModelException(msg + leafRef.getPath());
        exc.setCharPosition(leafRef.getCharPosition());
        exc.setLine(leafRef.getLineNumber());
        return exc;
    }
}

