/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangDecimal64;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class FractionDigitsListener {
    private FractionDigitsListener() {
    }

    public static void processFractionDigitsEntry(TreeWalkListener listener, GeneratedYangParser.FractionDigitStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.FRACTION_DIGITS_DATA, ctx.fraction().getText(), ListenerErrorLocation.ENTRY);
        int value = FractionDigitsListener.getValidFractionDigits(ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (tmpNode instanceof YangType) {
            YangType typeNode = (YangType)tmpNode;
            YangDecimal64 decimal64Node = (YangDecimal64)typeNode.getDataTypeExtendedInfo();
            decimal64Node.setFractionDigit(value);
            if (!decimal64Node.isValidFractionDigit()) {
                throw new ParserException(FractionDigitsListener.constructErrorMsg(ctx, ListenerErrorType.INVALID_CONTENT));
            }
        } else {
            throw new ParserException(FractionDigitsListener.constructErrorMsg(ctx, ListenerErrorType.INVALID_HOLDER));
        }
    }

    private static String constructErrorMsg(GeneratedYangParser.FractionDigitStatementContext ctx, ListenerErrorType type) {
        return ListenerErrorMessageConstruction.constructListenerErrorMessage(type, YangConstructType.FRACTION_DIGITS_DATA, ctx.fraction().getText(), ListenerErrorLocation.ENTRY);
    }

    private static int getValidFractionDigits(GeneratedYangParser.FractionDigitStatementContext ctx) {
        String value = ctx.fraction().getText().trim();
        int fractionDigits = Integer.parseInt(value);
        if (fractionDigits >= 1 && fractionDigits <= 18) {
            return fractionDigits;
        }
        ParserException parserException = new ParserException("YANG file error : fraction-digits value should be between 1 and 18.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }
}

