/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import java.util.List;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangResolutionInfo;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class ModuleListener {
    private ModuleListener() {
    }

    public static void processModuleEntry(TreeWalkListener listener, GeneratedYangParser.ModuleStatementContext ctx) {
        ListenerValidation.checkStackIsEmpty(listener, ListenerErrorType.INVALID_HOLDER, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.MODULE_DATA, ctx);
        YangModule yangModule = YangDataModelFactory.getYangModuleNode(GeneratedLanguage.JAVA_GENERATION);
        yangModule.setName(identifier);
        yangModule.setLineNumber(ctx.getStart().getLine());
        yangModule.setCharPosition(ctx.getStart().getCharPositionInLine());
        yangModule.setFileName(listener.getFileName());
        if (ctx.moduleBody().moduleHeaderStatement().yangVersionStatement() == null) {
            yangModule.setVersion("1");
        }
        listener.getParsedDataStack().push(yangModule);
    }

    public static void processModuleExit(TreeWalkListener listener, GeneratedYangParser.ModuleStatementContext ctx) {
        YangModule module;
        List<YangResolutionInfo> info;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangModule)) {
            ModuleListener.throwError(ListenerErrorType.MISSING_CURRENT_HOLDER, ctx);
        }
        if ((info = (module = (YangModule)tmpNode).getUnresolvedResolutionList(ResolvableType.YANG_COMPILER_ANNOTATION)) != null && !info.isEmpty() && module.getChild() != null) {
            ModuleListener.throwError(ListenerErrorType.INVALID_CHILD, ctx);
        }
        YangReferenceResolver resolver = (YangReferenceResolver)((Object)listener.getParsedDataStack().peek());
        try {
            resolver.resolveSelfFileLinking(ResolvableType.YANG_IF_FEATURE);
            resolver.resolveSelfFileLinking(ResolvableType.YANG_USES);
            resolver.resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
            resolver.resolveSelfFileLinking(ResolvableType.YANG_LEAFREF);
            resolver.resolveSelfFileLinking(ResolvableType.YANG_BASE);
            resolver.resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
        }
        catch (DataModelException e) {
            LinkerException linkerException = new LinkerException(e.getMessage());
            linkerException.setLine(e.getLineNumber());
            linkerException.setCharPosition(e.getCharPositionInLine());
            linkerException.setFileName(listener.getFileName());
            throw linkerException;
        }
        try {
            DataModelUtils.validateMultipleDeviationStatement(module);
        }
        catch (DataModelException e) {
            throw new ParserException(e.getMessage());
        }
    }

    private static void throwError(ListenerErrorType type, GeneratedYangParser.ModuleStatementContext ctx) {
        throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(type, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
    }
}

