/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.javamodel;

import java.util.Stack;
import org.onosproject.yang.compiler.datamodel.ConflictResolveNode;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaEnumerationTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaIdentityTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaTypeDefTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaUnionTranslator;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class AttributesJavaDataType {
    private AttributesJavaDataType() {
    }

    public static String getJavaDataType(YangType<?> yangType) {
        YangDataTypes type = yangType.getDataType();
        switch (type) {
            case INT8: {
                return "byte";
            }
            case INT16: {
                return "short";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "long";
            }
            case UINT8: {
                return "short";
            }
            case UINT16: {
                return "int";
            }
            case UINT32: {
                return "long";
            }
            case UINT64: {
                return "BigInteger";
            }
            case BITS: {
                return "BitSet";
            }
            case BINARY: {
                return "byte[]";
            }
            case DECIMAL64: {
                return "BigDecimal";
            }
            case STRING: {
                return "String";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INSTANCE_IDENTIFIER: {
                return "String";
            }
            case LEAFREF: {
                YangType<?> refType = AttributesJavaDataType.getReferredTypeFromLeafref(yangType);
                if (refType == null) {
                    return "Object";
                }
                return AttributesJavaDataType.getJavaDataType(AttributesJavaDataType.getReferredTypeFromLeafref(yangType));
            }
        }
        throw new TranslatorException("given data type is not supported. " + yangType.getDataTypeName() + " in " + yangType.getLineNumber() + " at " + yangType.getCharPosition() + " in " + yangType.getFileName());
    }

    public static String getJavaImportClass(YangType<?> yangType, boolean isListAttr, YangToJavaNamingConflictUtil pluginConfig) {
        YangDataTypes type = yangType.getDataType();
        if (isListAttr) {
            switch (type) {
                case INT8: {
                    return "Byte";
                }
                case INT16: {
                    return "Short";
                }
                case INT32: {
                    return "Integer";
                }
                case INT64: {
                    return "Long";
                }
                case UINT8: {
                    return "Short";
                }
                case UINT16: {
                    return "Integer";
                }
                case UINT32: {
                    return "Long";
                }
                case UINT64: {
                    return "BigInteger";
                }
                case DECIMAL64: {
                    return "BigDecimal";
                }
                case STRING: {
                    return "String";
                }
                case BOOLEAN: {
                    return "Boolean";
                }
                case ENUMERATION: {
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaEnumerationTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
                }
                case BITS: {
                    return "BitSet";
                }
                case BINARY: {
                    return "byte[]";
                }
                case LEAFREF: {
                    return AttributesJavaDataType.getLeafRefImpClass(yangType, pluginConfig, true);
                }
                case IDENTITYREF: {
                    return AttributesJavaDataType.getIdentityRefImpClass(yangType, pluginConfig);
                }
                case EMPTY: {
                    return "Boolean";
                }
                case UNION: {
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaUnionTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
                }
                case INSTANCE_IDENTIFIER: {
                    return "String";
                }
                case DERIVED: {
                    return AttributesJavaDataType.getDerivedImplClass(yangType, pluginConfig);
                }
            }
            throw new TranslatorException("given data type is not supported ." + yangType.getDataTypeName() + " in " + yangType.getLineNumber() + " at " + yangType.getCharPosition() + " in " + yangType.getFileName());
        }
        switch (type) {
            case UINT64: {
                return "BigInteger";
            }
            case STRING: {
                return "String";
            }
            case ENUMERATION: {
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaEnumerationTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
            }
            case BITS: {
                return "BitSet";
            }
            case DECIMAL64: {
                return "BigDecimal";
            }
            case LEAFREF: {
                return AttributesJavaDataType.getLeafRefImpClass(yangType, pluginConfig, false);
            }
            case IDENTITYREF: {
                return AttributesJavaDataType.getIdentityRefImpClass(yangType, pluginConfig);
            }
            case EMPTY: {
                return "boolean";
            }
            case UNION: {
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaUnionTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
            }
            case INSTANCE_IDENTIFIER: {
                return "String";
            }
            case DERIVED: {
                return AttributesJavaDataType.getDerivedImplClass(yangType, pluginConfig);
            }
        }
        return null;
    }

    private static String getDerivedImplClass(YangType<?> yangType, YangToJavaNamingConflictUtil pluginConfig) {
        String name = yangType.getDataTypeName();
        YangDerivedInfo derivedInfo = (YangDerivedInfo)yangType.getDataTypeExtendedInfo();
        YangTypeDef typeDef = derivedInfo.getReferredTypeDef();
        if (typeDef.isNameConflict()) {
            name = name + "_typedef";
        }
        return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(name, pluginConfig));
    }

    public static String getJavaImportPackage(YangType<?> yangType, boolean isListAttr, YangToJavaNamingConflictUtil conflictResolver) {
        YangDataTypes type = yangType.getDataType();
        if (isListAttr) {
            switch (type) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case BINARY: 
                case STRING: 
                case BOOLEAN: 
                case EMPTY: {
                    return "java.lang";
                }
                case UINT64: 
                case DECIMAL64: {
                    return "java.math";
                }
                case ENUMERATION: {
                    return AttributesJavaDataType.getEnumsPackage(yangType, conflictResolver);
                }
                case BITS: {
                    return "java.util";
                }
                case LEAFREF: {
                    return AttributesJavaDataType.getLeafRefImpPkg(yangType, conflictResolver, true);
                }
                case IDENTITYREF: {
                    return AttributesJavaDataType.getIdentityRefPackage(yangType, conflictResolver);
                }
                case UNION: {
                    return AttributesJavaDataType.getUnionPackage(yangType, conflictResolver);
                }
                case INSTANCE_IDENTIFIER: {
                    return "java.lang";
                }
                case DERIVED: {
                    return AttributesJavaDataType.getTypeDefsPackage(yangType, conflictResolver);
                }
            }
            throw new TranslatorException("given data type is not supported. " + yangType.getDataTypeName() + " in " + yangType.getLineNumber() + " at " + yangType.getCharPosition() + " in " + yangType.getFileName());
        }
        switch (type) {
            case UINT64: 
            case DECIMAL64: {
                return "java.math";
            }
            case STRING: 
            case EMPTY: {
                return "java.lang";
            }
            case ENUMERATION: {
                return AttributesJavaDataType.getEnumsPackage(yangType, conflictResolver);
            }
            case BITS: {
                return "java.util";
            }
            case LEAFREF: {
                return AttributesJavaDataType.getLeafRefImpPkg(yangType, conflictResolver, false);
            }
            case IDENTITYREF: {
                return AttributesJavaDataType.getIdentityRefPackage(yangType, conflictResolver);
            }
            case UNION: {
                return AttributesJavaDataType.getUnionPackage(yangType, conflictResolver);
            }
            case INSTANCE_IDENTIFIER: {
                return "java.lang";
            }
            case DERIVED: {
                return AttributesJavaDataType.getTypeDefsPackage(yangType, conflictResolver);
            }
        }
        return null;
    }

    private static String getTypeDefsPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        Object var = type.getDataTypeExtendedInfo();
        if (!(var instanceof YangDerivedInfo)) {
            throw new TranslatorException("type should have been derived. " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
        }
        if (((YangDerivedInfo)var).getReferredTypeDef() == null) {
            throw new TranslatorException("derived info is not an instance of typedef. " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
        }
        YangJavaTypeDefTranslator typedef = (YangJavaTypeDefTranslator)((YangDerivedInfo)var).getReferredTypeDef();
        return AttributesJavaDataType.getTypePackage(typedef, conflictResolver);
    }

    private static String getUnionPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangUnion)) {
            throw new TranslatorException("type should have been union. " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
        }
        YangJavaUnionTranslator union = (YangJavaUnionTranslator)type.getDataTypeExtendedInfo();
        return AttributesJavaDataType.getTypePackage(union, conflictResolver);
    }

    private static String getEnumsPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangEnumeration)) {
            throw new TranslatorException("type should have been enumeration. " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
        }
        YangJavaEnumerationTranslator enumeration = (YangJavaEnumerationTranslator)type.getDataTypeExtendedInfo();
        return AttributesJavaDataType.getTypePackage(enumeration, conflictResolver);
    }

    private static String getIdentityRefPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangIdentityRef)) {
            throw new TranslatorException("type should have been identityref. " + type.getDataTypeName() + " in " + type.getLineNumber() + " at " + type.getCharPosition() + " in " + type.getFileName());
        }
        YangIdentityRef identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
        if (identityRef.isInGrouping()) {
            return "java.lang";
        }
        YangJavaIdentityTranslator identity = (YangJavaIdentityTranslator)identityRef.getReferredIdentity();
        return AttributesJavaDataType.getTypePackage(identity, conflictResolver);
    }

    public static String getTypePackage(JavaCodeGeneratorInfo info, YangToJavaNamingConflictUtil conf) {
        YangNode node = (YangNode)((Object)info);
        while (node.getReferredSchema() != null) {
            node = (YangNode)node.getReferredSchema();
        }
        info = (JavaCodeGeneratorInfo)((Object)node);
        if (info.getJavaFileInfo().getPackage() == null) {
            return AttributesJavaDataType.getPackageFromParent(node.getParent(), conf);
        }
        return info.getJavaFileInfo().getPackage();
    }

    private static String getPackageFromParent(YangNode parent, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(parent instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("invalid child node is being processed. " + parent.getName() + " in " + parent.getLineNumber() + " at " + parent.getCharPosition() + " in " + parent.getFileName());
        }
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        if (parentInfo.getPackage() == null) {
            AttributesJavaDataType.updateJavaFileInfo(parent, conflictResolver);
        }
        return parentInfo.getPackage() + "." + parentInfo.getJavaName().toLowerCase();
    }

    public static void updateJavaFileInfo(YangNode yangNode, YangToJavaNamingConflictUtil conf) {
        Stack<YangNode> nodesToUpdatePackage = new Stack<YangNode>();
        while (yangNode != null && ((JavaFileInfoContainer)((Object)yangNode)).getJavaFileInfo().getPackage() == null) {
            nodesToUpdatePackage.push(yangNode);
            yangNode = yangNode.getParent();
        }
        if (yangNode == null) {
            String pkg;
            yangNode = (YangNode)nodesToUpdatePackage.pop();
            if (yangNode instanceof YangJavaModuleTranslator) {
                YangJavaModuleTranslator module = (YangJavaModuleTranslator)yangNode;
                pkg = JavaIdentifierSyntax.getRootPackage(module.getVersion(), module.getModuleName(), module.getRevision(), conf);
            } else if (yangNode instanceof YangJavaSubModuleTranslator) {
                YangJavaSubModuleTranslator submodule = (YangJavaSubModuleTranslator)yangNode;
                pkg = JavaIdentifierSyntax.getRootPackage(submodule.getVersion(), submodule.getModuleName(), submodule.getRevision(), conf);
            } else {
                throw new TranslatorException("Invalid root node of data model tree " + yangNode.getName() + " in " + yangNode.getLineNumber() + " at " + yangNode.getCharPosition() + " in " + yangNode.getFileName());
            }
            AttributesJavaDataType.setJavaCodeGenInfo(yangNode, conf, pkg);
        }
        while (nodesToUpdatePackage.size() != 0) {
            yangNode = (YangNode)nodesToUpdatePackage.pop();
            AttributesJavaDataType.setJavaCodeGenInfo(yangNode, conf, YangJavaModelUtils.getCurNodePackage(yangNode));
        }
    }

    private static void setJavaCodeGenInfo(YangNode node, YangToJavaNamingConflictUtil conf, String pkg) {
        String name = node.getName();
        JavaFileInfoTranslator info = ((JavaCodeGeneratorInfo)((Object)node)).getJavaFileInfo();
        if (node instanceof ConflictResolveNode && ((ConflictResolveNode)((Object)node)).isNameConflict()) {
            name = name + ((ConflictResolveNode)((Object)node)).getSuffix();
        }
        info.setJavaName(YangIoUtils.getCamelCase(name, conf));
        info.setPackage(pkg);
        info.setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(pkg));
    }

    private static YangType<?> getReferredTypeFromLeafref(YangType type) {
        YangLeafRef lri = (YangLeafRef)type.getDataTypeExtendedInfo();
        return lri.isInGrouping() ? null : lri.getEffectiveDataType();
    }

    public static String getLeafRefImpClass(YangType type, YangToJavaNamingConflictUtil cnfg, boolean isList) {
        YangType<?> rt = AttributesJavaDataType.getReferredTypeFromLeafref(type);
        return rt == null ? "Object" : AttributesJavaDataType.getJavaImportClass(rt, isList, cnfg);
    }

    public static String getIdentityRefImpClass(YangType type, YangToJavaNamingConflictUtil cnfg) {
        YangIdentityRef ir = (YangIdentityRef)type.getDataTypeExtendedInfo();
        if (ir.isInGrouping()) {
            return "Object";
        }
        YangIdentity identity = ir.getReferredIdentity();
        return YangIoUtils.getCapitalCase(AttributesJavaDataType.getIdJavaName(identity, cnfg));
    }

    public static String getIdJavaName(YangIdentity id, YangToJavaNamingConflictUtil cnfg) {
        String name = id.getName();
        if (id.isNameConflict()) {
            name = name + "_identity";
        }
        return YangIoUtils.getCamelCase(name, cnfg);
    }

    private static String getLeafRefImpPkg(YangType type, YangToJavaNamingConflictUtil cnfg, boolean isList) {
        YangType<?> rt = AttributesJavaDataType.getReferredTypeFromLeafref(type);
        return rt == null ? "java.lang" : AttributesJavaDataType.getJavaImportPackage(rt, isList, cnfg);
    }
}

