/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.onosproject.yang.compiler.datamodel.InvalidOpTypeHolder;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangCompilerAnnotation;
import org.onosproject.yang.compiler.datamodel.YangDataStructure;
import org.onosproject.yang.compiler.datamodel.YangEnum;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.translator.tojava.JavaAttributeInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.utils.BracketType;
import org.onosproject.yang.compiler.translator.tojava.utils.IndentationType;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodBodyTypes;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodClassTypes;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.ValidatorTypeForUnionTypes;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class MethodsGenerator {
    private static final String BIT_NAMES_VAR = "bitNames";
    private static final String BIT_NAME_VAR = "bitName";

    private MethodsGenerator() {
    }

    public static String getGetterString(JavaAttributeInfo attr, int genType) {
        YangDataStructure data;
        String returnType = JavaFileGeneratorUtils.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        String appDataStructure = null;
        StringBuilder builder = new StringBuilder();
        if (attr.getCompilerAnnotation() != null && (data = JavaFileGeneratorUtils.getYangDataStructure(attr.getCompilerAnnotation())) != null) {
            appDataStructure = data.name();
        }
        if (genType == 16) {
            builder.append(JavaDocGen.generateForGetMethodWithAttribute(returnType)).append(MethodsGenerator.getGetterForInterface(attributeName, returnType, attr.isListAttr(), genType, attr.getCompilerAnnotation()));
            return builder.toString();
        }
        builder.append(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attributeName, attr.isListAttr(), appDataStructure)).append(MethodsGenerator.getGetterForInterface(attributeName, returnType, attr.isListAttr(), genType, attr.getCompilerAnnotation()));
        return builder.toString();
    }

    public static String getSetterString(JavaAttributeInfo attr, String className, int genType) {
        String attrType = JavaFileGeneratorUtils.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        StringBuilder builder = new StringBuilder();
        JavaDocGen.JavaDocType type = genType == 16 ? JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD : JavaDocGen.JavaDocType.SETTER_METHOD;
        String appDataStructure = null;
        YangDataStructure ds = JavaFileGeneratorUtils.getYangDataStructure(attr.getCompilerAnnotation());
        if (ds != null) {
            appDataStructure = ds.name();
        }
        builder.append(JavaDocGen.getJavaDoc(type, attributeName, attr.isListAttr(), appDataStructure)).append(MethodsGenerator.getSetterForInterface(attributeName, attrType, className, attr.isListAttr(), genType, attr.getCompilerAnnotation()));
        return builder.toString();
    }

    private static String getConstructorString(String name) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.CONSTRUCTOR, name, false, null);
    }

    public static String getDefaultConstructorString(String name, String modifierType) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.DEFAULT_CONSTRUCTOR, name, false, null) + MethodsGenerator.getDefaultConstructor(name, modifierType) + "\n";
    }

    public static String getAddAugmentationString() {
        return StringGenerator.getOverRideString() + MethodsGenerator.getAddAugmentation();
    }

    public static String getRemoveAugmentationString() {
        return StringGenerator.getOverRideString() + MethodsGenerator.getRemoveAugmentation();
    }

    public static String getAugmentationsString() {
        return StringGenerator.getOverRideString() + MethodsGenerator.getAugmentations();
    }

    public static String getAugmentationString() {
        return StringGenerator.getOverRideString() + MethodsGenerator.getAugmentation();
    }

    public static String getGetterForClass(JavaAttributeInfo attr, int generatedJavaFiles) {
        String attrQualifiedType = JavaFileGeneratorUtils.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        if (!attr.isListAttr()) {
            return MethodsGenerator.getGetter(attrQualifiedType, attributeName, generatedJavaFiles);
        }
        String attrParam = StringGenerator.getListAttribute(attrQualifiedType, attr.getCompilerAnnotation());
        return MethodsGenerator.getGetter(attrParam, attributeName, generatedJavaFiles);
    }

    static String getGetter(String type, String name, int genType) {
        StringBuilder builder = new StringBuilder();
        if (genType == 16) {
            builder.append(StringGenerator.methodSignature(YangIoUtils.getCapitalCase(name), "get", "public", null, type, null, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.methodBody(MethodBodyTypes.MANAGER_METHODS, null, null, "        ", null, type, false, null)).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
            return builder.toString();
        }
        builder.append(StringGenerator.methodSignature(name, "", "public", null, type, null, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.methodBody(MethodBodyTypes.GETTER, name, name, "        ", null, type, false, null)).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getSetterForClass(JavaAttributeInfo attr, int generatedJavaFiles) {
        String attrQualifiedType = JavaFileGeneratorUtils.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        boolean isTypeNull = false;
        if (attr.getAttributeType() == null) {
            isTypeNull = true;
        }
        if (!attr.isListAttr()) {
            return MethodsGenerator.getSetter(attributeName, attrQualifiedType, generatedJavaFiles, isTypeNull);
        }
        String attrParam = StringGenerator.getListAttribute(attrQualifiedType, attr.getCompilerAnnotation());
        return MethodsGenerator.getSetter(attributeName, attrParam, generatedJavaFiles, isTypeNull);
    }

    private static String getSetter(String name, String type, int genType, boolean isTypeNull) {
        StringBuilder builder = new StringBuilder();
        if (genType == 16) {
            builder.append(StringGenerator.methodSignature(YangIoUtils.getCapitalCase(name), "set", "public", name, "void", type, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.methodBody(MethodBodyTypes.MANAGER_METHODS, null, null, "        ", null, null, false, null)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
            return builder.toString();
        }
        if (genType == 1024) {
            builder.append(StringGenerator.methodSignature(name, "", "public", name, "void", type, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.methodBody(MethodBodyTypes.SETTER, name, name, "        ", null, null, false, null)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
            return builder.toString();
        }
        builder.append(StringGenerator.methodSignature(name, "", "public", name, "void", type, MethodClassTypes.CLASS_TYPE));
        if (!isTypeNull && genType != 64 && genType != 128) {
            builder.append(StringGenerator.getLeafFlagSetString(name, "valueLeafFlags", "        ", "set")).append(StringGenerator.signatureClose());
        } else {
            builder.append("");
        }
        builder.append(StringGenerator.methodBody(MethodBodyTypes.SETTER, name, name, "        ", null, null, false, null)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    static String getSetterForTypeDefClass(JavaAttributeInfo attr) {
        String attrQualifiedType = JavaFileGeneratorUtils.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        return MethodsGenerator.getTypeDefSetter(attrQualifiedType, attributeName);
    }

    private static String getTypeDefSetter(String type, String name) {
        return StringGenerator.methodSignature(YangIoUtils.getCapitalCase(name), "set", "public", name, "void", type, MethodClassTypes.CLASS_TYPE) + StringGenerator.methodBody(MethodBodyTypes.SETTER, name, name, "        ", null, null, false, null) + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    static String getGetterForInterface(String yangName, String returnType, boolean isList, int genType, YangCompilerAnnotation annotation) {
        if (!isList) {
            return MethodsGenerator.getGetterInterfaceString(returnType, yangName, genType);
        }
        String listAttr = StringGenerator.getListAttribute(returnType, annotation);
        return MethodsGenerator.getGetterInterfaceString(listAttr, yangName, genType);
    }

    private static String getGetterInterfaceString(String returnType, String yangName, int genType) {
        switch (genType) {
            case 16: {
                return MethodsGenerator.getGetMethodWithArgument(returnType, yangName);
            }
        }
        return StringGenerator.methodSignature(yangName, "", null, null, returnType, null, MethodClassTypes.INTERFACE_TYPE);
    }

    static String getSetterForInterface(String attrName, String attrType, String className, boolean isList, int genType, YangCompilerAnnotation annotation) {
        if (!isList) {
            return StringGenerator.getSetterInterfaceString(className, attrName, attrType, genType);
        }
        String listAttr = StringGenerator.getListAttribute(attrType, annotation);
        return StringGenerator.getSetterInterfaceString(className, attrName, listAttr, genType);
    }

    public static String getConstructor(JavaAttributeInfo attr, int genType) {
        String attrName = attr.getAttributeName();
        String attrCaps = YangIoUtils.getCapitalCase(attrName);
        switch (genType) {
            case 16: {
                return StringGenerator.methodBody(MethodBodyTypes.CONSTRUCTOR, attrName, attrCaps, "        ", "get", null, false, null);
            }
        }
        return StringGenerator.methodBody(MethodBodyTypes.DEFAULT_CONSTRUCTOR, null, attrName, "        ", "", null, false, null);
    }

    public static String getRpcServiceMethod(String rpcName, String input, String output) {
        String inputVal = null;
        if (input != null) {
            inputVal = "inputVar";
        }
        return StringGenerator.methodSignature(rpcName, "", null, inputVal, output, input, MethodClassTypes.INTERFACE_TYPE) + "\n";
    }

    private static String getDefaultConstructor(String name, String modifierType) {
        return StringGenerator.methodSignature(name, "", modifierType, null, null, null, MethodClassTypes.CLASS_TYPE) + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    private static String getAddAugmentation() {
        return StringGenerator.methodSignature("addAugmentation", "", "public", "obj", "void", "InnerModelObject", MethodClassTypes.CLASS_TYPE) + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    private static String getRemoveAugmentation() {
        return StringGenerator.methodSignature("removeAugmentation", "", "public", "obj", "void", "InnerModelObject", MethodClassTypes.CLASS_TYPE) + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    private static String getAugmentations() {
        String methodReturnType = "Map<Class<? extends InnerModelObject>, InnerModelObject>";
        return StringGenerator.methodSignature("augmentations", "", "public", null, methodReturnType, null, MethodClassTypes.CLASS_TYPE) + "\n" + StringGenerator.getReturnString("null", "        ") + ";" + "\n" + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    private static String getAugmentation() {
        String methodReturnType = "<T extends InnerModelObject> T";
        String paraReturntype = "Class<T>";
        return StringGenerator.methodSignature("augmentation", "", "public", "c", methodReturnType, paraReturntype, MethodClassTypes.CLASS_TYPE) + "\n" + StringGenerator.getReturnString("null", "        ") + ";" + "\n" + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    static String getToStringMethodOpen() {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString());
        builder.append(StringGenerator.methodSignature("toString", "", "public", null, "String", null, MethodClassTypes.CLASS_TYPE));
        builder.append(StringGenerator.getReturnString("new StringJoiner(\", \", getClass().getSimpleName() +\"{\", \"}\")", "        ")).append("\n");
        return builder.toString();
    }

    static String getToStringMethodClose() {
        return "            .toString" + StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET, null, null) + StringGenerator.signatureClose() + StringGenerator.methodClose(IndentationType.FOUR_SPACE) + "\n";
    }

    public static String getToStringMethod(JavaAttributeInfo attr) {
        return StringGenerator.methodBody(MethodBodyTypes.TO_STRING, attr.getAttributeName(), null, "            ", null, null, false, null);
    }

    static String getFromStringMethodSignature(String className) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.FROM_METHOD, className, false, null) + StringGenerator.methodSignature("fromString", "", "public static", "valInString", className, "String", MethodClassTypes.CLASS_TYPE);
    }

    static String getFromStringMethodClose() {
        return StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    public static String getFromStringMethod(JavaAttributeInfo attr, JavaAttributeInfo fromAttr) {
        return "        " + StringGenerator.getTrySubString() + StringGenerator.getNewLineAndSpace("            ") + MethodsGenerator.getParsedSubString(attr, fromAttr) + StringGenerator.getReturnOfSubString() + "        " + StringGenerator.getCatchSubString(attr.getCurHolderOrCount());
    }

    private static String getParsedSubString(JavaAttributeInfo attr, JavaAttributeInfo fromStringAttr) {
        String targetDataType = JavaFileGeneratorUtils.getReturnType(attr);
        YangDataTypes types = fromStringAttr.getAttributeType().getDataType();
        StringBuilder method = new StringBuilder();
        switch (types) {
            case BITS: {
                return targetDataType + " " + "tmpVal" + " " + "=" + " " + YangIoUtils.getCapitalCase(attr.getAttributeName()) + "." + "fromString" + StringGenerator.getOpenCloseParaWithValue("valInString") + StringGenerator.signatureClose();
            }
            case BINARY: {
                return method.append(targetDataType).append(" ").append("tmpVal").append(" ").append("=").append(" ").append(MethodsGenerator.geStringConverterForBinary("valInString")).append(StringGenerator.signatureClose()).toString();
            }
        }
        return targetDataType + " " + "tmpVal" + " " + "=" + " " + StringGenerator.getParseFromStringMethod(targetDataType, fromStringAttr.getAttributeType()) + StringGenerator.getOpenCloseParaWithValue("valInString") + StringGenerator.signatureClose();
    }

    private static String geStringConverterForBinary(String var) {
        StringBuilder builder = new StringBuilder();
        return builder.append("Base64").append(".").append("getDecoder").append("()").append(".").append("decode").append(StringGenerator.getOpenCloseParaWithValue(var)).toString();
    }

    private static String getToStringForBinary(String var) {
        StringBuilder builder = new StringBuilder();
        return builder.append("Base64").append(".").append("getEncoder").append("()").append(".").append("encodeToString").append(StringGenerator.getOpenCloseParaWithValue(var)).toString();
    }

    static String getHashCodeMethodOpen() {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString());
        builder.append(StringGenerator.methodSignature("hashCode", "", "public", null, "int", null, MethodClassTypes.CLASS_TYPE));
        String line = StringGenerator.getReturnString("Objects.hash(", "        ");
        builder.append(line);
        return builder.toString();
    }

    static String getHashCodeMethodClose(String hashcodeString) {
        String[] array = new String[]{" ", ","};
        hashcodeString = YangIoUtils.trimAtLast(hashcodeString, array);
        return hashcodeString + ")" + StringGenerator.signatureClose() + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    public static String getHashCodeMethod(JavaAttributeInfo attr) {
        return attr.getAttributeName() + "," + " ";
    }

    static String getEqualsMethodOpen(String className) {
        return StringGenerator.getOverRideString() + StringGenerator.methodSignature("equals", "", "public", "obj", "boolean", "Object", MethodClassTypes.CLASS_TYPE) + MethodsGenerator.getEqualsMethodsCommonIfCondition() + MethodsGenerator.getEqualsMethodsSpecificIfCondition(className);
    }

    private static String getEqualsMethodsCommonIfCondition() {
        return StringGenerator.getIfConditionBegin("        ", "this == obj") + StringGenerator.getReturnString("true", "            ") + StringGenerator.signatureClose() + StringGenerator.methodClose(IndentationType.EIGHT_SPACE);
    }

    private static String getEqualsMethodsSpecificIfCondition(String className) {
        return "        if (obj instanceof " + className + ")" + " " + "{" + "\n" + "            " + className + " " + "other" + " " + "=" + " " + "(" + className + ")" + " " + "obj" + ";" + "\n" + "            " + "return" + "\n";
    }

    static String getEqualsMethodClose(String equalMethodString) {
        String[] array = new String[]{"\n", "&", "&", " "};
        equalMethodString = YangIoUtils.trimAtLast(equalMethodString, array) + StringGenerator.signatureClose();
        return equalMethodString + StringGenerator.methodClose(IndentationType.EIGHT_SPACE) + StringGenerator.getReturnString("false", "        ") + StringGenerator.signatureClose() + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    public static String getEqualsMethod(JavaAttributeInfo attr) {
        String attributeName = attr.getAttributeName();
        if (attributeName.contains("OpType")) {
            return "                Objects\n                .deepEquals(" + attributeName + "," + "\n" + "                " + " " + "other" + "." + attributeName + ") &&";
        }
        return "                Objects.deepEquals(" + attributeName + ", " + "other" + "." + attributeName + ") &&";
    }

    public static String getOfMethodStringAndJavaDoc(JavaAttributeInfo attr, String className) {
        String attrType = JavaFileGeneratorUtils.getReturnType(attr);
        String attrName = attr.getAttributeName();
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.OF_METHOD, className + " for type " + attrName, false, null) + MethodsGenerator.getOfMethodString(attrType, className);
    }

    private static String getOfMethodString(String type, String name) {
        return StringGenerator.methodSignature("of", "", "public static", "value", name, type, MethodClassTypes.CLASS_TYPE) + StringGenerator.methodBody(MethodBodyTypes.OF_METHOD, name, null, "        ", "", null, false, null) + StringGenerator.methodClose(IndentationType.FOUR_SPACE);
    }

    public static String getTypeConstructorStringAndJavaDoc(JavaAttributeInfo attr, String className, int genType, int count) {
        String attrType = JavaFileGeneratorUtils.getReturnType(attr);
        String attrName = attr.getAttributeName();
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, attrName, false, null) + MethodsGenerator.getTypeConstructorString(attrType, attrName, className, genType, count);
    }

    public static String getTypeConstructorStringAndJavaDoc(JavaAttributeInfo attr1, JavaAttributeInfo attr2, String genType, ValidatorTypeForUnionTypes type, boolean addFirst, int count) {
        String attrType = JavaFileGeneratorUtils.getReturnType(attr1);
        String attrName1 = "";
        String attrName2 = "";
        if (attr1 != null) {
            if (addFirst) {
                attrName1 = attr1.getAttributeName();
            } else {
                attrName2 = attr1.getAttributeName();
            }
        }
        if (attr2 != null) {
            if (addFirst) {
                attrName2 = attr2.getAttributeName();
            } else {
                attrName1 = attr2.getAttributeName();
            }
        }
        String appDataStructure = null;
        if (attr1 != null && attr1.getCompilerAnnotation() != null) {
            appDataStructure = attr1.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        String doc = attrName1.isEmpty() ? attrName2 : attrName1;
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, doc, false, appDataStructure) + MethodsGenerator.getTypeConstructorString(attrType, attrName1, attrName2, genType, type, addFirst, count);
    }

    private static String getTypeConstructorString(String type, String name, String className, int genType, int count) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringGenerator.methodSignature(className, "", "public", name, null, type, MethodClassTypes.CLASS_TYPE));
        if (genType == 128) {
            builder.append("        ").append("setValue").append(".").append("set").append(StringGenerator.getOpenCloseParaWithValue(count + "")).append(StringGenerator.signatureClose());
        }
        builder.append(StringGenerator.methodBody(MethodBodyTypes.SETTER, name, null, "        ", "", null, false, null)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    private static String getTypeConstructorString(String type, String attr1, String attr2, String className, ValidatorTypeForUnionTypes validatorType, boolean addInt, int count) {
        StringBuilder constructor = new StringBuilder(StringGenerator.methodSignature(className, "", "public", attr1, null, type, MethodClassTypes.CLASS_TYPE)).append("        ").append("setValue").append(".").append("set").append(StringGenerator.getOpenCloseParaWithValue(count + "")).append(StringGenerator.signatureClose()).append(StringGenerator.ifConditionForIntInTypeDefConstructor(validatorType, addInt, attr1)).append(StringGenerator.methodBody(MethodBodyTypes.SETTER, attr1, null, "            ", "", null, false, attr1));
        String str = "        } else {\n";
        constructor.append(str).append(StringGenerator.methodBody(MethodBodyTypes.SETTER, attr2, null, "            ", "", null, false, attr1)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE)).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        return constructor.toString();
    }

    static String getEnumsConstructor(String className) {
        StringBuilder builder = new StringBuilder(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, className, false, null));
        String clsName = YangIoUtils.getSmallCase(className);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(clsName, "int");
        map.put("schemaName", "String");
        builder.append(StringGenerator.multiAttrMethodSignature(className, "", "", null, map, MethodClassTypes.CLASS_TYPE, "    ")).append(StringGenerator.methodBody(MethodBodyTypes.SETTER, clsName, "", "        ", "", "", false, null)).append(StringGenerator.methodBody(MethodBodyTypes.SETTER, "schemaName", "", "        ", "", "", false, null)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    static String getEnumsOfValueMethod(String className, YangEnumeration enumeration, MethodBodyTypes type) {
        String name = YangIoUtils.getCapitalCase(className);
        StringBuilder builder = new StringBuilder(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.OF_METHOD, name + " " + "for", false, null));
        String sw = "        switch " + StringGenerator.getOpenCloseParaWithValue("value") + StringGenerator.methodSignatureClose(MethodClassTypes.CLASS_TYPE);
        switch (type) {
            case ENUM_METHOD_INT_VALUE: {
                builder.append(MethodsGenerator.getEnumValueMethodSignature(name, "int")).append(sw);
                for (YangEnum yangEnum : enumeration.getEnumSet()) {
                    String str = JavaIdentifierSyntax.getEnumJavaAttribute(yangEnum.getNamedValue()).toUpperCase();
                    builder.append(MethodsGenerator.getEnumValueMethodCases("" + yangEnum.getValue(), str, name));
                }
                break;
            }
            case ENUM_METHOD_STRING_VALUE: {
                builder.append(MethodsGenerator.getEnumValueMethodSignature(name, "String")).append(sw);
                for (YangEnum yangEnum : enumeration.getEnumSet()) {
                    String str = JavaIdentifierSyntax.getEnumJavaAttribute(yangEnum.getNamedValue()).toUpperCase();
                    builder.append(MethodsGenerator.getEnumValueMethodCases("\"" + TranslatorUtils.getEnumYangName(yangEnum.getNamedValue()) + "\"", str, name));
                }
                break;
            }
            default: {
                return null;
            }
        }
        String method = "            default :\n";
        builder.append(method).append(StringGenerator.getExceptionThrowString("                ")).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE)).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    private static String getEnumValueMethodSignature(String name, String type) {
        return StringGenerator.methodSignature("of", "", "public static", "value", name, type, MethodClassTypes.CLASS_TYPE);
    }

    private static String getEnumValueMethodCases(String caseType, String value, String name) {
        return "            case " + caseType + ":" + "\n" + StringGenerator.getReturnString(name, "                ") + "." + value + StringGenerator.signatureClose();
    }

    static String getAugmentsDataMethodForService(YangNode parent) {
        List<YangAtomicPath> targets = JavaFileGeneratorUtils.getSetOfNodeIdentifiers(parent);
        if (targets.isEmpty()) {
            return "";
        }
        YangNode first = targets.get(0).getResolvedNode();
        if (first instanceof InvalidOpTypeHolder) {
            return "";
        }
        StringBuilder methods = new StringBuilder();
        YangPluginConfig pluginConfig = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo().getPluginConfig();
        for (YangAtomicPath nodeId : targets) {
            YangNode augmentedNode = nodeId.getResolvedNode().getParent();
            YangNode methodNode = nodeId.getResolvedNode();
            String curNodeName = ((JavaFileInfoContainer)((Object)methodNode)).getJavaFileInfo().getJavaName() != null ? ((JavaFileInfoContainer)((Object)methodNode)).getJavaFileInfo().getJavaName() : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(methodNode.getName(), pluginConfig.getConflictResolver()));
            String returnType = JavaFileGeneratorUtils.getAugmentedClassNameForDataMethods(augmentedNode, parent);
            String parentName = JavaFileGeneratorUtils.getCurNodeName(augmentedNode, pluginConfig);
            String method = JavaDocGen.generateForGetMethodWithAttribute(returnType) + MethodsGenerator.getGetMethodWithArgument(returnType, "Augmented" + parentName + YangIoUtils.getCapitalCase(curNodeName)) + "\n";
            methods.append(method);
            method = JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD, "Augmented" + YangIoUtils.getCapitalCase(parentName) + YangIoUtils.getCapitalCase(curNodeName), false, null) + MethodsGenerator.getSetterForInterface(YangIoUtils.getSmallCase("Augmented") + parentName + YangIoUtils.getCapitalCase(curNodeName), returnType, parentName, false, 16, null) + "\n";
            methods.append(method);
        }
        return methods.toString();
    }

    static String getRangeValidatorMethodForUnion(String type) {
        String newType = type.contentEquals("BigInteger") ? "long" : "int";
        StringBuilder builder = new StringBuilder(JavaDocGen.generateForValidatorMethod());
        String var = YangIoUtils.getSmallCase("BigInteger");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("minRange", type);
        map.put("maxRange", type);
        map.put("value", newType);
        builder.append(StringGenerator.multiAttrMethodSignature("validateRange", "", "private", "boolean", map, MethodClassTypes.CLASS_TYPE, "    "));
        if (type.contentEquals("BigInteger")) {
            builder.append(StringGenerator.getNewInstance("BigInteger", var, "        ", "\" \" + value")).append(StringGenerator.getReturnString(var, "        ")).append(StringGenerator.getCompareToString()).append(StringGenerator.ifAndAndCondition(StringGenerator.ifEqualEqualCondition(StringGenerator.getOpenCloseParaWithValue("minRange"), "1"), var)).append(StringGenerator.getCompareToString()).append(StringGenerator.ifEqualEqualCondition(StringGenerator.getOpenCloseParaWithValue("maxRange"), "1")).append(StringGenerator.signatureClose());
        } else {
            builder.append(StringGenerator.getReturnString("value", "        ")).append(StringGenerator.getGreaterThanCondition()).append(StringGenerator.ifAndAndCondition("minRange", "value")).append(StringGenerator.getLesserThanCondition()).append("maxRange").append(StringGenerator.signatureClose());
        }
        builder.append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    private static String getGetMethodWithArgument(String returnType, String yangName) {
        return StringGenerator.methodSignature(YangIoUtils.getCapitalCase(yangName), "get", null, YangIoUtils.getSmallCase(returnType), returnType, returnType + "OpParam", MethodClassTypes.INTERFACE_TYPE);
    }

    public static String getAddToListMethodImpl(JavaAttributeInfo attr, String name) {
        String attrName = attr.getAttributeName();
        String retString = StringGenerator.getOverRideString();
        String methodName = "addTo" + YangIoUtils.getCapitalCase(attrName);
        StringBuilder builder = new StringBuilder(retString);
        String retType = JavaFileGeneratorUtils.getReturnType(attr);
        YangDataStructure struct = JavaFileGeneratorUtils.getYangDataStructure(attr.getCompilerAnnotation());
        if (struct != null) {
            switch (struct) {
                case MAP: {
                    LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
                    param.put(attr.getAttributeName() + "Keys", retType + "Keys");
                    param.put(attr.getAttributeName() + "Value", retType);
                    builder.append(StringGenerator.multiAttrMethodSignature(methodName, null, "public", "void", param, MethodClassTypes.CLASS_TYPE, "    ")).append(MethodsGenerator.getIfConditionForAddToListMethod(attr));
                    retString = "        " + attrName + "." + "put" + StringGenerator.getOpenCloseParaWithValue(attrName + "Keys" + "," + " " + attrName + "Value");
                    break;
                }
                default: {
                    builder.append(StringGenerator.methodSignature(methodName, null, "public", "addTo", "void", retType, MethodClassTypes.CLASS_TYPE)).append(MethodsGenerator.getIfConditionForAddToListMethod(attr));
                    retString = "        " + attrName + "." + "add" + "(" + "add" + "To" + ")";
                    break;
                }
            }
        } else {
            builder.append(StringGenerator.methodSignature("addTo" + YangIoUtils.getCapitalCase(attrName), null, "public", "addTo", "void", retType, MethodClassTypes.CLASS_TYPE)).append(MethodsGenerator.getIfConditionForAddToListMethod(attr));
            retString = "        " + attrName + "." + "add" + "(" + "add" + "To" + ")";
        }
        builder.append(retString).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    private static String getIfConditionForAddToListMethod(JavaAttributeInfo attr) {
        String type;
        String name = attr.getAttributeName();
        YangDataStructure struct = JavaFileGeneratorUtils.getYangDataStructure(attr.getCompilerAnnotation());
        if (struct != null) {
            switch (struct) {
                case QUEUE: {
                    type = "java.util.PriorityQueue<>()";
                    break;
                }
                case LIST: {
                    type = "ArrayList<>()";
                    break;
                }
                case MAP: {
                    type = "java.util.LinkedHashMap<>()";
                    break;
                }
                case SET: {
                    type = "java.util.LinkedHashSet<>()";
                    break;
                }
                default: {
                    type = "ArrayList<>()";
                    break;
                }
            }
        } else {
            type = "ArrayList<>()";
        }
        return StringGenerator.getIfConditionBegin("        ", name + " " + "=" + "=" + " " + "null") + "            " + name + " " + "=" + " " + "new" + " " + type + StringGenerator.signatureClose() + StringGenerator.methodClose(IndentationType.EIGHT_SPACE);
    }

    static String isLeafValueSetInterface() {
        String method = "\n    /**\n     * Checks if the leaf value is set.\n     *\n     * @param leaf leaf whose value status needs to checked\n     * @return result of leaf value set in object\n     */\n";
        return method + StringGenerator.methodSignature("isLeafValueSet", "", null, "leaf", "boolean", "LeafIdentifier", MethodClassTypes.INTERFACE_TYPE);
    }

    static String getInterfaceLeafIdEnumSignature(String name) {
        String start = "\n    /**\n     * Identify the leaf of " + name + "." + "\n" + "     */\n";
        return start + "    " + "public" + " " + "enum" + " " + "LeafIdentifier" + " " + "implements" + " " + "org.onosproject.yang.model.LeafIdentifier" + "{" + "\n";
    }

    private static String getFromStringForBits(String bitClassName) {
        StringBuilder sBuild = new StringBuilder();
        sBuild.append(StringGenerator.methodSignature("fromString", null, "public static", "valInString", "BitSet", "String", MethodClassTypes.CLASS_TYPE)).append("        ").append(StringGenerator.getBitSetAttr(""));
        sBuild.append("        ").append("String").append("[]").append(" ").append(BIT_NAMES_VAR).append(" ").append("=").append(" ").append("valInString").append(".").append("trim").append("()").append(".").append("split").append(StringGenerator.getOpenCloseParaWithValue(StringGenerator.getPatternQuoteString(" "))).append(StringGenerator.signatureClose()).append(StringGenerator.getForLoopString("        ", "String", BIT_NAME_VAR, BIT_NAMES_VAR));
        String small = YangIoUtils.getSmallCase(bitClassName);
        sBuild.append("            ").append(bitClassName).append(" ").append(small).append(" ").append("=").append(" ").append("of").append(StringGenerator.getOpenCloseParaWithValue(BIT_NAME_VAR)).append(StringGenerator.signatureClose());
        String condition = small + " " + "!" + "=" + " " + "null";
        sBuild.append(StringGenerator.getIfConditionBegin("            ", condition)).append("                ").append("tmpVal").append(".").append("set").append("(").append(small).append(".").append(small).append("()").append(")").append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.TWELVE_SPACE)).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        condition = "tmpVal.isEmpty()";
        sBuild.append(StringGenerator.getIfConditionBegin("        ", condition));
        sBuild.append(StringGenerator.getExceptionThrowString("            ")).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE)).append(StringGenerator.getReturnString("tmpVal", "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return sBuild.toString();
    }

    static String getToStringForType(String attr, YangType type) {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString()).append(StringGenerator.methodSignature("toString", null, "public", null, "String", null, MethodClassTypes.CLASS_TYPE));
        if (type.getDataType() == YangDataTypes.IDENTITYREF) {
            builder.append(MethodsGenerator.getToStringForSpecialType(type, attr)).append(StringGenerator.getReturnString(null, "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        } else {
            builder.append(StringGenerator.getReturnString(MethodsGenerator.getToStringForSpecialType(type, attr), "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        }
        return builder.toString();
    }

    private static String getToStringForSpecialType(YangType type, String name) {
        switch (type.getDataType()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return "String.valueOf" + StringGenerator.getOpenCloseParaWithValue(name);
            }
            case BINARY: {
                return StringGenerator.getToStringCall(MethodsGenerator.getToStringForBinary(name));
            }
            case BITS: {
                return YangIoUtils.getCapitalCase(name) + "." + "toString" + StringGenerator.getOpenCloseParaWithValue(name);
            }
            case BOOLEAN: 
            case EMPTY: {
                return name + " " + "?" + " " + StringGenerator.getQuotedString("true") + " " + ":" + " " + StringGenerator.getQuotedString("false");
            }
            case LEAFREF: {
                YangLeafRef lri = (YangLeafRef)type.getDataTypeExtendedInfo();
                YangType rt = lri.isInGrouping() ? null : lri.getEffectiveDataType();
                return rt == null ? StringGenerator.getToStringCall(name) : MethodsGenerator.getToStringForSpecialType(rt, name);
            }
            case IDENTITYREF: {
                return MethodsGenerator.getIdRefToString(type, name, "");
            }
            case ENUMERATION: 
            case INSTANCE_IDENTIFIER: 
            case UINT64: 
            case DECIMAL64: 
            case DERIVED: 
            case UNION: {
                return StringGenerator.getToStringCall(name);
            }
        }
        return name;
    }

    private static String getIdRefToString(YangType type, String name, String indent) {
        YangIdentityRef ir = (YangIdentityRef)type.getDataTypeExtendedInfo();
        StringBuilder builder = new StringBuilder();
        String idName = YangIoUtils.getCamelCase(TranslatorUtils.getIdentityRefName(type), null);
        YangIdentity identity = ir.getReferredIdentity();
        String cond = StringGenerator.getTwoParaEqualsString(name, YangIoUtils.getCapitalCase(idName) + "." + "class");
        String returnVal = YangIoUtils.getCapitalCase(idName) + "." + YangIoUtils.getCamelCase(identity.getName(), null) + "To" + "String" + "()";
        List<YangIdentity> idList = identity.getExtendList();
        builder.append(StringGenerator.getIfConditionBegin("        " + indent, cond)).append(StringGenerator.getReturnString(returnVal, "            " + indent)).append(StringGenerator.signatureClose());
        for (YangIdentity id : idList) {
            idName = JavaFileGeneratorUtils.getIdName(id);
            cond = StringGenerator.getTwoParaEqualsString(name, YangIoUtils.getCapitalCase(idName) + "." + "class");
            returnVal = YangIoUtils.getCapitalCase(idName) + "." + YangIoUtils.getCamelCase(id.getName(), null) + "To" + "String" + "()";
            builder.append(StringGenerator.getElseIfConditionBegin("        " + indent, cond)).append(StringGenerator.getReturnString(returnVal, "            " + indent)).append(StringGenerator.signatureClose());
        }
        if (indent.equals("    ")) {
            builder.append(StringGenerator.methodClose(IndentationType.TWELVE_SPACE));
        } else {
            builder.append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        }
        return builder.toString();
    }

    static String getUnionToStringMethod(List<YangType<?>> types) {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString());
        builder.append(StringGenerator.methodSignature("toString", null, "public", null, "String", null, MethodClassTypes.CLASS_TYPE));
        for (YangType<?> type : types) {
            builder.append(StringGenerator.getIfConditionBegin("        ", StringGenerator.getSetValueParaCondition(types.indexOf(type))));
            String retVal = MethodsGenerator.getToStringForSpecialType(type, YangIoUtils.getCamelCase(type.getDataTypeName(), null));
            if (type.getDataType() != YangDataTypes.IDENTITYREF) {
                builder.append(StringGenerator.getReturnString(retVal, "            ")).append(StringGenerator.signatureClose());
            } else {
                retVal = MethodsGenerator.getIdRefToString(type, YangIoUtils.getCamelCase(type.getDataTypeName(), null), "    ");
                builder.append(retVal);
            }
            builder.append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        }
        builder.append(StringGenerator.getReturnString("null", "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    static String getBitSetEnumClassFromString(String className) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.FROM_METHOD, className, false, null) + MethodsGenerator.getFromStringForBits(className);
    }

    static String getBitSetEnumClassToString(String className, YangEnumeration enumeration) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringGenerator.methodSignature("toString", null, "public static", "bits", "String", "BitSet", MethodClassTypes.CLASS_TYPE)).append(StringGenerator.getStringBuilderAttr("", "        "));
        for (YangEnum yangEnum : enumeration.getEnumSet()) {
            String name = yangEnum.getNamedValue();
            String condition = "bits.get(" + className + "." + JavaIdentifierSyntax.getEnumJavaAttribute(name).toUpperCase() + "." + YangIoUtils.getSmallCase(className) + "()" + ")";
            builder.append(StringGenerator.getIfConditionBegin("        ", condition)).append("            ").append("sBuild").append(".").append("append").append("(").append(StringGenerator.getQuotedString(name)).append(")").append(StringGenerator.signatureClose()).append("            ").append("sBuild").append(".").append("append").append("(").append(StringGenerator.getQuotedString(" ")).append(")").append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE));
        }
        builder.append(StringGenerator.getReturnString("sBuild", "        ")).append(".").append("toString").append("()").append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    static String getToStringForEnumClass() {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString());
        builder.append(StringGenerator.methodSignature("toString", "", "public", null, "String", null, MethodClassTypes.CLASS_TYPE));
        builder.append(StringGenerator.getReturnString("schemaName", "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getToStringMethodForIdentity(String name) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, name, false, null));
        String returnVal = StringGenerator.getQuotedString(name);
        String methodName = YangIoUtils.getCamelCase(name, null) + "To" + "String";
        builder.append(StringGenerator.methodSignature(methodName, null, "public static", null, "String", null, MethodClassTypes.CLASS_TYPE)).append(StringGenerator.getReturnString(returnVal, "        ")).append(StringGenerator.signatureClose()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getFromStringMethodForIdentity(String name, String schemaName, List<YangIdentity> idList) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.FROM_METHOD, name, false, null));
        String caps = YangIoUtils.getCapitalCase(name);
        String returnVal = caps + "." + "class";
        String cond = StringGenerator.getTwoParaEqualsString("valInString", StringGenerator.getQuotedString(schemaName));
        builder.append(StringGenerator.methodSignature("fromString", null, "public static", "valInString", "Class", "String", MethodClassTypes.CLASS_TYPE)).append(StringGenerator.getIfConditionBegin("        ", cond)).append(StringGenerator.getReturnString(returnVal, "            ")).append(StringGenerator.signatureClose());
        if (idList != null) {
            for (YangIdentity id : idList) {
                cond = StringGenerator.getTwoParaEqualsString("valInString", StringGenerator.getQuotedString(id.getName()));
                name = id.isNameConflict() ? YangIoUtils.getCamelCase(id.getName() + "_identity", null) : YangIoUtils.getCamelCase(id.getName(), null);
                caps = YangIoUtils.getCapitalCase(name);
                returnVal = caps + "." + "class";
                builder.append(StringGenerator.getElseIfConditionBegin("        ", cond)).append(StringGenerator.getReturnString(returnVal, "            ")).append(StringGenerator.signatureClose());
            }
        }
        builder.append(StringGenerator.methodClose(IndentationType.EIGHT_SPACE)).append(StringGenerator.getExceptionThrowString("        ")).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getParaMeterisiedConstructor(String name, String modifierType, Map<String, String> params, String space) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringGenerator.multiAttrMethodSignature(name, null, modifierType, null, params, MethodClassTypes.CLASS_TYPE, space));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.append(StringGenerator.valueAssign("this." + entry.getKey(), entry.getKey(), space + "    "));
        }
        builder.append(space).append("}").append("\n");
        return builder.toString();
    }
}

