/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.LeafSchemaContext;
import org.onosproject.yang.model.LeafType;
import org.onosproject.yang.model.ListSchemaContext;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;
import org.onosproject.yang.model.YangNamespace;
import org.onosproject.yang.runtime.ExtResourceIdBldr;
import org.onosproject.yang.runtime.HelperContext;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;

public final class SerializerHelper {
    private static final String FMT_TOO_FEW = "Too few key parameters in %s. Expected %d; actual %d.";
    private static final String FMT_TOO_MANY = "Too many key parameters in %s. Expected %d; actual %d.";
    private static final String FMT_NOT_EXIST = "Schema node with name %s doesn't exist.";
    private static final String E_NAMESPACE = "NameSpace is mandatory to provide for first level node.";
    private static final String E_LEAFLIST = "Method is not allowed to pass multiple values for leaf-list.";
    private static final String E_RESID = "Invalid resourceId builder.";
    private static final String SLASH = "/";

    private SerializerHelper() {
    }

    public static ResourceId.Builder initializeResourceId(YangSerializerContext context) {
        SchemaContext cont = context.getContext();
        SchemaId id = cont.getSchemaId();
        ResourceId.Builder rIdBdr = ResourceId.builder();
        rIdBdr.addBranchPointSchema(id.name(), id.namespace());
        rIdBdr.appInfo((Object)cont);
        return rIdBdr;
    }

    public static ResourceId.Builder addToResourceId(ResourceId.Builder builder, String name, String namespace, String value) {
        try {
            SchemaContext parentCont = (SchemaContext)builder.appInfo();
            SchemaContext child = SerializerHelper.getChildSchemaContext(parentCont, name, namespace);
            if (child == null) {
                throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_NOT_EXIST, name));
            }
            DataNode.Type type = child.getType();
            SerializerHelper.updateResourceId(builder, name, value, child, type);
            if (type == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE && ((YangLeaf)child).isKeyLeaf()) {
                builder.appInfo((Object)parentCont);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return builder;
    }

    public static ResourceId.Builder addToResourceId(ResourceId.Builder builder, String name, String namespace, List<String> value) throws IllegalArgumentException {
        SchemaContext child;
        block8: {
            child = SerializerHelper.getChildSchemaContext((SchemaContext)builder.appInfo(), name, namespace);
            namespace = child.getSchemaId().namespace();
            DataNode.Type childType = child.getType();
            try {
                if (childType == DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE) {
                    if (value.size() > 1) {
                        throw new IllegalArgumentException(SerializerHelper.errorMsg(E_LEAFLIST, new Object[0]));
                    }
                    Object valObject = ((LeafSchemaContext)child).fromString(value.get(0));
                    builder.addLeafListBranchPoint(name, namespace, valObject);
                    break block8;
                }
                if (childType == DataNode.Type.MULTI_INSTANCE_NODE) {
                    String v = null;
                    builder = SerializerHelper.addToResourceId(builder, name, namespace, v);
                    if (value == null || value.size() == 0) break block8;
                    Set keyLeafs = ((ListSchemaContext)child).getKeyLeaf();
                    try {
                        SerializerHelper.checkElementCount(name, keyLeafs.size(), value.size());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                    Iterator sklIter = keyLeafs.iterator();
                    for (String val : value) {
                        String keyEleName = (String)sklIter.next();
                        SchemaContext keyChild = SerializerHelper.getChildSchemaContext((SchemaContext)builder.appInfo(), keyEleName, namespace);
                        Object valObject = ((LeafSchemaContext)keyChild).fromString(val);
                        builder.addKeyLeaf(keyEleName, namespace, valObject);
                    }
                    break block8;
                }
                throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_NOT_EXIST, name));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        builder.appInfo((Object)child);
        return builder;
    }

    public static DataNode.Builder initializeDataNode(ResourceId.Builder builder) {
        ExtResourceIdBldr rIdBldr = new ExtResourceIdBldr();
        rIdBldr = rIdBldr.copyBuilder(rIdBldr, builder.build());
        rIdBldr.appInfo(builder.appInfo());
        SchemaContext node = (SchemaContext)builder.appInfo();
        HelperContext info = new HelperContext();
        info.setResourceIdBuilder(null);
        info.setParentResourceIdBldr(rIdBldr);
        SchemaId sId = node.getSchemaId();
        InnerNode.Builder dBldr = (InnerNode.Builder)InnerNode.builder((String)sId.name(), (String)sId.namespace()).type(node.getType());
        dBldr.appInfo((Object)info);
        return dBldr;
    }

    public static DataNode.Builder initializeDataNode(YangSerializerContext context) {
        SchemaContext node = context.getContext();
        SchemaId sId = node.getSchemaId();
        HelperContext info = new HelperContext();
        ExtResourceIdBldr rId = info.getResourceIdBuilder();
        rId.addBranchPointSchema(sId.name(), sId.namespace());
        rId.appInfo(node);
        info.setResourceIdBuilder(rId);
        InnerNode.Builder dBlr = InnerNode.builder((String)sId.name(), (String)sId.namespace());
        dBlr.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        dBlr.appInfo((Object)info);
        return dBlr;
    }

    public static DataNode.Builder addDataNode(DataNode.Builder builder, String name, String namespace, String value, DataNode.Type type) {
        return SerializerHelper.addDataNode(builder, name, namespace, value, null, type);
    }

    public static DataNode.Builder addDataNode(DataNode.Builder builder, String name, String namespace, String value, String valNamespace, DataNode.Type type) {
        try {
            HelperContext nodeInfo;
            SchemaContext node;
            ExtResourceIdBldr rIdBldr;
            boolean initWithRId = false;
            HelperContext info = (HelperContext)builder.appInfo();
            ExtResourceIdBldr curBldr = info.getResourceIdBuilder();
            if (curBldr != null) {
                rIdBldr = info.getResourceIdBuilder();
                node = (SchemaContext)rIdBldr.appInfo();
                nodeInfo = new HelperContext();
                initWithRId = true;
            } else {
                node = (SchemaContext)info.getParentResourceIdBldr().appInfo();
                rIdBldr = info.getParentResourceIdBldr();
                nodeInfo = info;
            }
            SchemaContext childSchema = SerializerHelper.getChildSchemaContext(node, name, namespace);
            DataNode.Type nodeType = childSchema.getType();
            if (type != null && !nodeType.equals((Object)type)) {
                throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_NOT_EXIST, name));
            }
            namespace = childSchema.getSchemaId().namespace();
            SerializerHelper.updateResourceId(rIdBldr, name, value, childSchema, nodeType);
            if (!initWithRId) {
                switch (nodeType) {
                    case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                        if (((YangLeaf)childSchema).isKeyLeaf()) {
                            throw new IllegalArgumentException(E_RESID);
                        }
                        LeafSchemaContext schema = (LeafSchemaContext)childSchema;
                        Object valObject = SerializerHelper.getLeaf(value, schema);
                        valNamespace = SerializerHelper.getValidValNamespace(value, schema, valNamespace);
                        LeafType lType = schema.getLeafType(value);
                        builder = ((LeafNode.Builder)LeafNode.builder((String)name, (String)namespace).type(nodeType)).value(valObject).valueNamespace(valNamespace).leafType(lType);
                        break;
                    }
                    case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                        LeafSchemaContext schema = (LeafSchemaContext)childSchema;
                        Object valObject = SerializerHelper.getLeafList(value, schema);
                        valNamespace = SerializerHelper.getValidValNamespace(value, schema, valNamespace);
                        LeafType lType = schema.getLeafType(value);
                        builder = ((LeafNode.Builder)LeafNode.builder((String)name, (String)namespace).type(nodeType)).value(valObject).valueNamespace(valNamespace).leafType(lType);
                        builder = builder.addLeafListValue(valObject);
                        break;
                    }
                    default: {
                        builder = InnerNode.builder((String)name, (String)namespace).type(nodeType);
                        break;
                    }
                }
            } else {
                switch (nodeType) {
                    case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                        LeafSchemaContext schema = (LeafSchemaContext)childSchema;
                        Object valObject = SerializerHelper.getLeaf(value, schema);
                        valNamespace = SerializerHelper.getValidValNamespace(value, schema, valNamespace);
                        LeafType lType = schema.getLeafType(value);
                        if (((YangLeaf)childSchema).isKeyLeaf()) {
                            builder = builder.addKeyLeaf(name, namespace, valObject);
                        }
                        builder = ((LeafNode.Builder)builder.createChildBuilder(name, namespace, valObject, valNamespace).type(nodeType)).leafType(lType);
                        break;
                    }
                    case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                        LeafSchemaContext schema = (LeafSchemaContext)childSchema;
                        Object valObject = SerializerHelper.getLeafList(value, schema);
                        valNamespace = SerializerHelper.getValidValNamespace(value, schema, valNamespace);
                        LeafType lType = schema.getLeafType(value);
                        builder = ((LeafNode.Builder)builder.createChildBuilder(name, namespace, valObject, valNamespace).type(nodeType)).leafType(lType);
                        builder = builder.addLeafListValue(valObject);
                        break;
                    }
                    default: {
                        builder = builder.createChildBuilder(name, namespace).type(nodeType);
                    }
                }
            }
            nodeInfo.setResourceIdBuilder(rIdBldr);
            builder.appInfo((Object)nodeInfo);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return builder;
    }

    private static Object getLeafList(String val, LeafSchemaContext ctx) throws IllegalArgumentException {
        try {
            ((YangLeafList)ctx).getDataType().isValidValue(val);
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ctx.fromString(val);
    }

    private static Object getLeaf(String val, LeafSchemaContext ctx) throws IllegalArgumentException {
        try {
            ((YangLeaf)ctx).getDataType().isValidValue(val);
        }
        catch (DataModelException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return ctx.fromString(val);
    }

    private static String getValidValNamespace(String val, LeafSchemaContext ctx, String actual) throws IllegalArgumentException {
        YangNamespace expected = ctx.getValueNamespace(val);
        if (actual == null) {
            if (expected == null || expected.getModuleNamespace().equals(ctx.getSchemaId().namespace())) {
                return null;
            }
        } else if (actual.equals(expected.getModuleName()) || actual.equals(expected.getModuleNamespace())) {
            return expected.getModuleNamespace();
        }
        throw new IllegalArgumentException("Invalid input for value namespace");
    }

    public static ResourceId getResourceId(DataNode.Builder builder) {
        HelperContext info = (HelperContext)builder.appInfo();
        if (info.getParentResourceIdBldr() != null) {
            return info.getParentResourceIdBldr().getResourceId();
        }
        return info.getResourceIdBuilder().getResourceId();
    }

    public static DataNode.Builder exitDataNode(DataNode.Builder builder) {
        HelperContext info = (HelperContext)builder.appInfo();
        ExtResourceIdBldr rId = info.getResourceIdBuilder();
        SchemaContext cont = (SchemaContext)rId.appInfo();
        if (cont.getType() == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
            if (!((YangLeaf)cont).isKeyLeaf()) {
                rId.traveseToParent();
            }
        } else {
            rId.traveseToParent();
        }
        rId.appInfo(cont.getParentContext());
        return builder.exitNode();
    }

    public static SchemaContext getChildSchemaContext(SchemaContext context, String name, String namespace) throws IllegalArgumentException {
        SchemaId id;
        SchemaContext child;
        SchemaId parentId = context.getSchemaId();
        if (namespace == null && parentId.name().equals(SLASH)) {
            throw new IllegalArgumentException(E_NAMESPACE);
        }
        if (namespace == null) {
            namespace = parentId.namespace();
        }
        if ((child = ((SingleInstanceNodeContext)context).getChildContext(id = new SchemaId(name, namespace))) == null) {
            throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_NOT_EXIST, name));
        }
        return child;
    }

    private static void checkElementCount(String name, int expected, int actual) throws IllegalArgumentException {
        if (expected < actual) {
            throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_TOO_MANY, name, expected, actual));
        }
        if (expected > actual) {
            throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_TOO_FEW, name, expected, actual));
        }
    }

    private static void updateResourceId(ResourceId.Builder builder, String name, String value, SchemaContext child, DataNode.Type type) throws IllegalArgumentException {
        switch (type) {
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: {
                if (((YangLeaf)child).isKeyLeaf()) {
                    Object valObject = ((LeafSchemaContext)child).fromString(value);
                    builder.addKeyLeaf(name, child.getSchemaId().namespace(), valObject);
                    break;
                }
                builder.addBranchPointSchema(name, child.getSchemaId().namespace());
                break;
            }
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                Object valObject = ((LeafSchemaContext)child).fromString(value);
                builder.addLeafListBranchPoint(name, child.getSchemaId().namespace(), valObject);
                break;
            }
            case MULTI_INSTANCE_NODE: 
            case SINGLE_INSTANCE_NODE: {
                if (value == null) {
                    builder.addBranchPointSchema(name, child.getSchemaId().namespace());
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException(SerializerHelper.errorMsg(FMT_NOT_EXIST, name));
            }
        }
        builder.appInfo((Object)child);
    }

    public static String errorMsg(String fmt, Object ... params) {
        return String.format(fmt, params);
    }

    public static String getModuleNameFromNameSpace(YangSerializerContext c, String ns) {
        YangSchemaNode schemaNode = ((DefaultYangModelRegistry)c.getContext()).getForNameSpace(ns, false);
        if (schemaNode != null) {
            return schemaNode.getName();
        }
        return null;
    }
}

