/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafIdentifier;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.LeafModelObject;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelConverterException;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YobUtils {
    public static final String FORWARD_SLASH = "/";
    private static final Logger log = LoggerFactory.getLogger(YobUtils.class);
    private static final String ENUM_LEAF_IDENTIFIER = "$LeafIdentifier";
    static final String ANYDATA_SETTER = "addAnydata";

    private YobUtils() {
    }

    static void setDataFromStringValue(YangDataTypes type, Object value, Method parentSetter, Object parentObj, YangSchemaNode schemaNode, YangSchemaNode parentSchema) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        switch (type) {
            case INT8: 
            case UINT8: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case INT64: 
            case UINT64: 
            case BOOLEAN: 
            case STRING: 
            case DECIMAL64: 
            case INSTANCE_IDENTIFIER: {
                parentSetter.invoke(parentObj, value);
                break;
            }
            case BINARY: {
                byte[] data = Base64.getDecoder().decode((String)value);
                parentSetter.invoke(parentObj, new Object[]{data});
                break;
            }
            case BITS: {
                YobUtils.parseBitSetTypeInfo(parentSetter, parentObj, value, schemaNode, parentSchema);
                break;
            }
            case DERIVED: {
                YobUtils.parseDerivedTypeInfo(parentSetter, parentObj, value, false, schemaNode);
                break;
            }
            case IDENTITYREF: {
                YobUtils.parseIdentityRefInfo(parentSetter, parentObj, value, schemaNode);
                break;
            }
            case UNION: {
                YobUtils.parseDerivedTypeInfo(parentSetter, parentObj, value, false, schemaNode);
                break;
            }
            case LEAFREF: {
                YobUtils.parseLeafRefTypeInfo(parentSetter, parentObj, value, schemaNode);
                break;
            }
            case ENUMERATION: {
                YobUtils.parseDerivedTypeInfo(parentSetter, parentObj, value.toString(), true, schemaNode);
                break;
            }
            case EMPTY: {
                if (value != null) break;
                parentSetter.invoke(parentObj, true);
                break;
            }
            default: {
                log.error("Given data type is not supported.");
            }
        }
    }

    static void parseDerivedTypeInfo(Method parentSetter, Object parentObj, Object value, boolean isEnum, YangSchemaNode leaf) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String val = value == null ? "true" : value.toString();
        Class<?> childSetClass = null;
        Constructor<?> childConstructor = null;
        Object childValue = null;
        Object childObject = null;
        Method childMethod = null;
        while (leaf.getReferredSchema() != null) {
            leaf = leaf.getReferredSchema();
        }
        String qualifiedClassName = leaf.getJavaPackage() + "." + YobUtils.getCapitalCase(leaf.getJavaClassNameOrBuiltInType());
        ClassLoader classLoader = parentObj.getClass().getClassLoader();
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (!isEnum) {
            if (childSetClass != null) {
                childConstructor = childSetClass.getDeclaredConstructor(new Class[0]);
            }
            if (childConstructor != null) {
                childConstructor.setAccessible(true);
            }
            try {
                if (childConstructor != null) {
                    childObject = childConstructor.newInstance(new Object[0]);
                }
            }
            catch (InstantiationException e) {
                log.error("Failed to load constructor for class: {}", (Object)qualifiedClassName);
            }
            if (childSetClass != null) {
                childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
            }
        } else if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("of", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(childObject, val);
        }
        parentSetter.invoke(parentObj, childValue);
    }

    static void parseBitSetTypeInfo(Method parentSetterMethod, Object parentObject, Object leafValue, YangSchemaNode leaf, YangSchemaNode parentSchema) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> childSetClass = null;
        Object childValue = null;
        Object childObject = null;
        Method childMethod = null;
        while (leaf.getReferredSchema() != null) {
            leaf = leaf.getReferredSchema();
        }
        String pName = parentSchema.getJavaClassNameOrBuiltInType().toLowerCase() + ".";
        String qualifiedClassName = parentSchema.getJavaPackage() + "." + pName + YobUtils.getCapitalCase(leaf.getJavaAttributeName());
        ClassLoader classLoader = parentObject.getClass().getClassLoader();
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(childObject, leafValue);
        }
        parentSetterMethod.invoke(parentObject, childValue);
    }

    static void parseLeafRefTypeInfo(Method parentSetter, Object parentObject, Object leafValue, YangSchemaNode schemaNode) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        while (schemaNode.getReferredSchema() != null) {
            schemaNode = schemaNode.getReferredSchema();
        }
        YangLeafRef leafRef = schemaNode instanceof YangLeaf ? (YangLeafRef)((YangLeaf)schemaNode).getDataType().getDataTypeExtendedInfo() : (YangLeafRef)((YangLeafList)schemaNode).getDataType().getDataTypeExtendedInfo();
        YangType type = leafRef.getEffectiveDataType();
        Object refLeaf = leafRef.getReferredLeafOrLeafList();
        YangLeavesHolder parent = refLeaf instanceof YangLeaf ? ((YangLeaf)refLeaf).getContainedIn() : ((YangLeafList)refLeaf).getContainedIn();
        YobUtils.setDataFromStringValue(type.getDataType(), leafValue, parentSetter, parentObject, (YangSchemaNode)refLeaf, (YangSchemaNode)((Object)parent));
    }

    static ClassLoader getClassLoader(YangSchemaNode schemaNode, DefaultYangModelRegistry reg) {
        YangSchemaNode curNode = schemaNode;
        while (!(curNode instanceof RpcNotificationContainer)) {
            curNode = ((YangNode)curNode).getParent();
        }
        Class<?> regClass = reg.getRegisteredClass(curNode);
        return regClass.getClassLoader();
    }

    static ClassLoader getTargetClassLoader(ClassLoader curLoader, YangSchemaNodeContextInfo context, DefaultYangModelRegistry reg) {
        YangSchemaNode augment = context.getContextSwitchedNode();
        if (augment.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
            YangNode parent = ((YangNode)augment).getParent();
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            Class<?> moduleClass = reg.getRegisteredClass(parent);
            if (moduleClass == null) {
                throw new ModelConverterException("Failed to load class for class: " + parent.getJavaClassNameOrBuiltInType());
            }
            return moduleClass.getClassLoader();
        }
        return curLoader;
    }

    static String getQualifiedDefaultClass(YangSchemaNode schemaNode) {
        String packageName = schemaNode.getJavaPackage();
        String className = YobUtils.getCapitalCase(schemaNode.getJavaClassNameOrBuiltInType());
        if (schemaNode instanceof RpcNotificationContainer) {
            return packageName + "." + className + "OpParam";
        }
        return packageName + "." + "Default" + className;
    }

    static String getQualifiedinterface(YangSchemaNode schemaNode) {
        String packageName = schemaNode.getJavaPackage();
        String className = YobUtils.getCapitalCase(schemaNode.getJavaClassNameOrBuiltInType());
        return packageName + "." + className;
    }

    static String getCapitalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static void parseIdentityRefInfo(Method parentSetterMethod, Object parentObject, Object leafValue, YangSchemaNode schemaNode) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> childSetClass = null;
        Object childValue = null;
        Method childMethod = null;
        while (schemaNode.getReferredSchema() != null) {
            schemaNode = schemaNode.getReferredSchema();
        }
        YangType<?> type = schemaNode instanceof YangLeaf ? ((YangLeaf)schemaNode).getDataType() : ((YangLeafList)schemaNode).getDataType();
        YangIdentityRef identityRef = null;
        if (type.getDataType() == YangDataTypes.LEAFREF && schemaNode.getJavaPackage().equals("java.lang")) {
            YangLeafRef leafref = (YangLeafRef)type.getDataTypeExtendedInfo();
            YangType effectiveType = leafref.getEffectiveDataType();
            if (effectiveType.getDataType() == YangDataTypes.IDENTITYREF) {
                identityRef = (YangIdentityRef)effectiveType.getDataTypeExtendedInfo();
            }
        } else {
            identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
        }
        YangIdentity derivedId = YobUtils.getDerivedIdentity(leafValue.toString(), identityRef.getReferredIdentity());
        if (derivedId == null) {
            throw new ModelConverterException("Value for identityref data type is invalid " + leafValue.toString());
        }
        String qualifiedClassName = derivedId.getJavaPackage() + "." + YobUtils.getCapitalCase(derivedId.getJavaClassNameOrBuiltInType());
        ClassLoader classLoader = parentObject.getClass().getClassLoader();
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(null, leafValue);
        }
        parentSetterMethod.invoke(parentObject, childValue);
    }

    static YangSchemaNode getChildSchemaNode(DataNode dataNode, SchemaContext context) {
        SchemaId schemaId = dataNode.key().schemaId();
        SchemaContext schemaContext = SerializerHelper.getChildSchemaContext(context, schemaId.name(), schemaId.namespace());
        return (YangSchemaNode)schemaContext;
    }

    static ModelObject buildLeafModelObject(DataNode dataNode, YangSchemaNode leafHolder, DefaultYangModelRegistry reg) {
        if (leafHolder == null) {
            YangSchemaNode schemaNode = (YangSchemaNode)reg.getChildContext(dataNode.key().schemaId());
            leafHolder = schemaNode instanceof YangLeaf ? (YangSchemaNode)((Object)((YangLeaf)schemaNode).getContainedIn()) : (YangSchemaNode)((Object)((YangLeafList)schemaNode).getContainedIn());
        }
        LeafModelObject leafObj = new LeafModelObject();
        leafObj.addValue(((LeafNode)dataNode).value());
        LeafIdentifier leafId = YobUtils.getLeafIdentifier(dataNode.key().schemaId(), leafHolder, reg);
        leafObj.leafIdentifier(leafId);
        return leafObj;
    }

    static LeafIdentifier getLeafIdentifier(SchemaId id, YangSchemaNode leafHolder, DefaultYangModelRegistry reg) {
        String qualName = YobUtils.getQualifiedDefaultClass(leafHolder);
        ClassLoader classLoader = YobUtils.getClassLoader(leafHolder, reg);
        try {
            Enum[] enumConst;
            Class<?> cls = classLoader.loadClass(qualName);
            Class<?>[] intfs = cls.getInterfaces();
            Class<?> intf = null;
            for (Class<?> in : intfs) {
                if (!in.getName().equals(YobUtils.getJavaQualifiedInterFaceName(leafHolder))) continue;
                intf = in;
                break;
            }
            if (intf == null) {
                throw new ModelConverterException("Failed to load leaf identifier class");
            }
            String leafId = intf.getName() + ENUM_LEAF_IDENTIFIER;
            Class<?> leafIdentifier = cls.getClassLoader().loadClass(leafId);
            for (Enum e : enumConst = (Enum[])leafIdentifier.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(id.name())) continue;
                return (LeafIdentifier)e;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelConverterException("Failed to load class for class: ", (Throwable)e);
        }
        return null;
    }

    static Class<?> fetchClassForNode(ClassLoader loader, String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ModelConverterException("Failed to load class for class: " + name, (Throwable)e);
        }
    }

    static Object getInstanceOfClass(ClassLoader loader, String name) {
        try {
            Class<?> defaultClass = loader.loadClass(name);
            return defaultClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)name);
            throw new ModelConverterException("Failed to load class for class: " + name, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error("Reflection failed to create an object for class: {}", (Object)name);
            throw new ModelConverterException("Reflection failed to create an object for class: " + name, (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Failed to create an object for class: {}", (Object)name);
            throw new ModelConverterException("Failed to create an object for class: " + name, (Throwable)e);
        }
    }

    static String getJavaQualifiedInterFaceName(YangSchemaNode node) {
        if (node != null) {
            return node.getJavaPackage() + "." + YobUtils.getCapitalCase(node.getJavaClassNameOrBuiltInType());
        }
        return null;
    }

    static String getKeyClassName(YangSchemaNode node) {
        if (node != null) {
            return YobUtils.getJavaQualifiedInterFaceName(node) + "Keys";
        }
        return null;
    }

    static YangLeaf getKeyLeafSchema(KeyLeaf keyleaf, YangSchemaNode node) {
        YangList list = (YangList)node;
        List<YangLeaf> keyLeaves = list.getListOfLeaf();
        for (YangLeaf leaf : keyLeaves) {
            if (!leaf.getName().equals(keyleaf.leafSchema().name())) continue;
            return leaf;
        }
        return null;
    }

    static <T extends InnerModelObject, K extends KeyInfo<T>> ModelObjectId.Builder handleListKey(ModelObjectId.Builder midb, DefaultYangModelRegistry reg, YangSchemaNode node, NodeKey key) {
        ListKey listKey = (ListKey)key;
        List keyLeaves = listKey.keyLeafs();
        String javaName = null;
        if (DataModelUtils.nonEmpty(keyLeaves)) {
            String qualName = YobUtils.getQualifiedDefaultClass(node);
            ClassLoader classLoader = YobUtils.getClassLoader(node, reg);
            Class<?> listClass = YobUtils.fetchClassForNode(classLoader, qualName);
            if (listClass != null) {
                String keyClassName = YobUtils.getKeyClassName(node);
                try {
                    Class<?> keyClass = listClass.getClassLoader().loadClass(keyClassName);
                    KeyInfo keyObj = (KeyInfo)keyClass.newInstance();
                    for (KeyLeaf leaf : keyLeaves) {
                        YangLeaf leafSchema = YobUtils.getKeyLeafSchema(leaf, node);
                        YangDataTypes datatype = leafSchema.getDataType().getDataType();
                        javaName = YangIoUtils.getCamelCase(leaf.leafSchema().name(), null);
                        Field leafName = keyClass.getDeclaredField(javaName);
                        Method setter = keyClass.getDeclaredMethod(javaName, leafName.getType());
                        Object value = leaf.leafValue();
                        YobUtils.setDataFromStringValue(datatype, value, setter, keyObj, leafSchema, node);
                        midb = midb.addChild(listClass, keyObj);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new ModelConverterException("Failed to load setter method for " + javaName + " in key class" + keyClassName, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ModelConverterException("Failed to invoke setter method for " + javaName + " in key class" + keyClassName, (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new ModelConverterException("Failed to load key class" + keyClassName, (Throwable)e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ModelConverterException("Failed Instantiation of key class" + keyClassName, (Throwable)e);
                }
                catch (NoSuchFieldException e) {
                    throw new ModelConverterException("Field " + javaName + " not found", (Throwable)e);
                }
            }
        }
        return midb;
    }

    static ModelObjectId.Builder handleLeafListKey(ModelObjectId.Builder midb, DefaultYangModelRegistry reg, YangSchemaNode schemaNode, LeafListKey key) {
        Class<?>[] interfaces;
        Class<?> intf = null;
        YangSchemaNode parentSchema = (YangSchemaNode)((Object)((YangLeafList)schemaNode).getContainedIn());
        String qualName = YobUtils.getQualifiedDefaultClass(parentSchema);
        ClassLoader classLoader = YobUtils.getClassLoader(parentSchema, reg);
        Class<?> parentClass = YobUtils.fetchClassForNode(classLoader, qualName);
        for (Class<?> in : interfaces = parentClass.getInterfaces()) {
            if (!in.getName().equals(YobUtils.getJavaQualifiedInterFaceName(parentSchema))) continue;
            intf = in;
            break;
        }
        if (intf != null) {
            String leafName = intf.getName() + ENUM_LEAF_IDENTIFIER;
            try {
                Enum[] enumConst;
                Class<?> leafId = parentClass.getClassLoader().loadClass(leafName);
                for (Enum e : enumConst = (Enum[])leafId.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(key.schemaId().name())) continue;
                    midb = midb.addChild((LeafIdentifier)e, key.value());
                    return midb;
                }
            }
            catch (ClassNotFoundException e) {
                throw new ModelConverterException("Failed to load leaf identifier class." + leafName, (Throwable)e);
            }
        }
        return midb;
    }

    static ModelObjectId.Builder handleNodeKey(ModelObjectId.Builder midb, DefaultYangModelRegistry reg, YangSchemaNode node, NodeKey key) {
        if (node != null) {
            if (!(node instanceof YangLeaf)) {
                String qualName = YobUtils.getQualifiedDefaultClass(node);
                ClassLoader classLoader = YobUtils.getClassLoader(node, reg);
                Class<?> nodeClass = YobUtils.fetchClassForNode(classLoader, qualName);
                if (nodeClass != null) {
                    midb = midb.addChild(nodeClass);
                }
            } else {
                midb = YobUtils.handleLeafInfo(midb, reg, key, node);
            }
        }
        return midb;
    }

    static ModelObjectId.Builder handleLeafInfo(ModelObjectId.Builder midb, DefaultYangModelRegistry reg, NodeKey key, YangSchemaNode schemaNode) {
        Class<?>[] interfaces;
        YangSchemaNode parentSchema = (YangSchemaNode)((Object)((YangLeaf)schemaNode).getContainedIn());
        String qualName = YobUtils.getQualifiedDefaultClass(parentSchema);
        ClassLoader classLoader = YobUtils.getClassLoader(parentSchema, reg);
        Class<?> nodeClass = YobUtils.fetchClassForNode(classLoader, qualName);
        for (Class<?> intf : interfaces = nodeClass.getInterfaces()) {
            String leafId = intf.getName() + ENUM_LEAF_IDENTIFIER;
            try {
                Enum[] enumConst;
                Class<?> leafIdentifier = nodeClass.getClassLoader().loadClass(leafId);
                for (Enum e : enumConst = (Enum[])leafIdentifier.getEnumConstants()) {
                    if (!e.name().equalsIgnoreCase(key.schemaId().name())) continue;
                    midb = midb.addChild((LeafIdentifier)e);
                    return midb;
                }
            }
            catch (ClassNotFoundException e) {
                throw new ModelConverterException("Failed to load leaf identifier class", (Throwable)e);
            }
        }
        return midb;
    }

    static YangIdentity getDerivedIdentity(String value, YangIdentity referredId) {
        if (referredId.getJavaClassNameOrBuiltInType().equalsIgnoreCase(value)) {
            return referredId;
        }
        List<YangIdentity> extendList = referredId.getExtendList();
        if (extendList != null && !extendList.isEmpty()) {
            for (YangIdentity identity : extendList) {
                if (!identity.getYangSchemaNodeIdentifier().getName().equalsIgnoreCase(value)) continue;
                return identity;
            }
        }
        return null;
    }
}

