/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of routerAlertLabel.
 */
public abstract class RouterAlertLabel extends MplsLabelSpecialPurposeValue {

    /**
     * Returns the attribute router-alert-label.
     *
     * @return router-alert-label value of router-alert-label
     */
    public static String routerAlertLabelToString() {
        return "router-alert-label";
    }

    /**
     * Returns the object of routerAlertLabel fromString input String routerAlertLabel.
     *
     * @param valInString value of input String
     * @return routerAlertLabel
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("router-alert-label")) {
            return RouterAlertLabel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}