/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv6multicastsourceaddress;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv6multicastsourceaddress.ipv6multicastsourceaddressunion.Ipv6MulticastSourceAddressUnionEnum1;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Address;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of ipv6MulticastSourceAddressUnion.
 */
public final class Ipv6MulticastSourceAddressUnion {
    private Ipv6MulticastSourceAddressUnionEnum1 enumeration;
    private Ipv6Address ipv6Address;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of ipv6MulticastSourceAddressUnion.
     */
    private Ipv6MulticastSourceAddressUnion() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Ipv6MulticastSourceAddressUnion(Ipv6MulticastSourceAddressUnionEnum1 enumeration) {
        setValue.set(0);
        this.enumeration = enumeration;
    }

    /**
     * Creates an instance of ipv6Address.
     *
     * @param ipv6Address value of ipv6Address
     */
    public Ipv6MulticastSourceAddressUnion(Ipv6Address ipv6Address) {
        setValue.set(1);
        this.ipv6Address = ipv6Address;
    }

    /**
     * Returns the object of ipv6MulticastSourceAddressUnion for type enumeration.
     *
     * @param value value of ipv6MulticastSourceAddressUnion for type enumeration
     * @return ipv6MulticastSourceAddressUnion for type enumeration
     */
    public static Ipv6MulticastSourceAddressUnion of(Ipv6MulticastSourceAddressUnionEnum1 value) {
        return new Ipv6MulticastSourceAddressUnion(value);
    }

    /**
     * Returns the object of ipv6MulticastSourceAddressUnion for type ipv6Address.
     *
     * @param value value of ipv6MulticastSourceAddressUnion for type ipv6Address
     * @return ipv6MulticastSourceAddressUnion for type ipv6Address
     */
    public static Ipv6MulticastSourceAddressUnion of(Ipv6Address value) {
        return new Ipv6MulticastSourceAddressUnion(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public Ipv6MulticastSourceAddressUnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Returns the attribute ipv6Address.
     *
     * @return ipv6Address value of ipv6Address
     */
    public Ipv6Address ipv6Address() {
        return ipv6Address;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(Ipv6MulticastSourceAddressUnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }
    /**
     * Sets the attribute ipv6Address.
     *
     * @param ipv6Address value of ipv6Address
     */
    public void ipv6Address(Ipv6Address ipv6Address) {
        this.ipv6Address = ipv6Address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration, ipv6Address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv6MulticastSourceAddressUnion) {
            Ipv6MulticastSourceAddressUnion other = (Ipv6MulticastSourceAddressUnion) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration) &&
                Objects.deepEquals(ipv6Address, other.ipv6Address);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return enumeration.toString();
        }
        if (setValue.get(1)) {
            return ipv6Address.toString();
        }
        return null;
    }
    /**
     * Returns the object of ipv6MulticastSourceAddressUnion fromString input String ipv6MulticastSourceAddressUnion.
     *
     * @param valInString value of input String
     * @return ipv6MulticastSourceAddressUnion
     */
    public static Ipv6MulticastSourceAddressUnion fromString(String valInString) {
        try {
            Ipv6MulticastSourceAddressUnionEnum1 tmpVal = Ipv6MulticastSourceAddressUnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Ipv6Address tmpVal = Ipv6Address.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
