/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.mplslabelstack.mplslabelstack;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of entry.
 */
public class EntryKeys implements KeyInfo<DefaultEntry> {
    protected short id;
    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    public short id() {
        return id;
    }

    /**
     * Sets the value to attribute id.
     *
     * @param id value of id
     */
    public void id(short id) {
        this.id = id;
    }


    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EntryKeys) {
            EntryKeys other = (EntryKeys) obj;
            return
                Objects.deepEquals(id, other.id);
        }
        return false;
    }
}