/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.routetargettype;

/**
 * Represents ENUM data of routeTargetTypeEnum.
 */
public enum RouteTargetTypeEnum {

    /**
     * Represents import.
     */
    IMPORT(0, "import"),

    /**
     * Represents export.
     */
    EXPORT(1, "export"),

    /**
     * Represents both.
     */
    BOTH(2, "both");

    private int routeTargetTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of routeTargetTypeEnum.
     *
     * @param routeTargetTypeEnum value of routeTargetTypeEnum
     */
     RouteTargetTypeEnum(int routeTargetTypeEnum, String schemaName) {
        this.routeTargetTypeEnum = routeTargetTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of routeTargetTypeEnum for.
     *
     * @param value value of routeTargetTypeEnum for
     * @return routeTargetTypeEnum for
     */
    public static RouteTargetTypeEnum of(int value) {
        switch (value) {
            case 0:
                return RouteTargetTypeEnum.IMPORT;
            case 1:
                return RouteTargetTypeEnum.EXPORT;
            case 2:
                return RouteTargetTypeEnum.BOTH;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of routeTargetTypeEnum for.
     *
     * @param value value of routeTargetTypeEnum for
     * @return routeTargetTypeEnum for
     */
    public static RouteTargetTypeEnum of(String value) {
        switch (value) {
            case "import":
                return RouteTargetTypeEnum.IMPORT;
            case "export":
                return RouteTargetTypeEnum.EXPORT;
            case "both":
                return RouteTargetTypeEnum.BOTH;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute routeTargetTypeEnum.
     *
     * @return routeTargetTypeEnum value of routeTargetTypeEnum
     */
    public int routeTargetTypeEnum() {
        return routeTargetTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
