/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervaluemilliseconds;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervaluemilliseconds.timervaluemillisecondsunion.TimerValueMillisecondsUnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of timerValueMillisecondsUnion.
 */
public final class TimerValueMillisecondsUnion {
    private long uint32;
    private TimerValueMillisecondsUnionEnum1 enumeration;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of timerValueMillisecondsUnion.
     */
    private TimerValueMillisecondsUnion() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public TimerValueMillisecondsUnion(long uint32) {
        setValue.set(0);
        this.uint32 = uint32;
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TimerValueMillisecondsUnion(TimerValueMillisecondsUnionEnum1 enumeration) {
        setValue.set(1);
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of timerValueMillisecondsUnion for type uint32.
     *
     * @param value value of timerValueMillisecondsUnion for type uint32
     * @return timerValueMillisecondsUnion for type uint32
     */
    public static TimerValueMillisecondsUnion of(long value) {
        return new TimerValueMillisecondsUnion(value);
    }

    /**
     * Returns the object of timerValueMillisecondsUnion for type enumeration.
     *
     * @param value value of timerValueMillisecondsUnion for type enumeration
     * @return timerValueMillisecondsUnion for type enumeration
     */
    public static TimerValueMillisecondsUnion of(TimerValueMillisecondsUnionEnum1 value) {
        return new TimerValueMillisecondsUnion(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TimerValueMillisecondsUnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TimerValueMillisecondsUnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32, enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimerValueMillisecondsUnion) {
            TimerValueMillisecondsUnion other = (TimerValueMillisecondsUnion) obj;
            return
                Objects.deepEquals(uint32, other.uint32) &&
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint32);
        }
        if (setValue.get(1)) {
            return enumeration.toString();
        }
        return null;
    }
    /**
     * Returns the object of timerValueMillisecondsUnion fromString input String timerValueMillisecondsUnion.
     *
     * @param valInString value of input String
     * @return timerValueMillisecondsUnion
     */
    public static TimerValueMillisecondsUnion fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            TimerValueMillisecondsUnionEnum1 tmpVal = TimerValueMillisecondsUnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
