/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of bidirProvisioningMode.
 */
public abstract class BidirProvisioningMode {

    /**
     * Returns the attribute bidir-provisioning-mode.
     *
     * @return bidir-provisioning-mode value of bidir-provisioning-mode
     */
    public static String bidirProvisioningModeToString() {
        return "bidir-provisioning-mode";
    }

    /**
     * Returns the object of bidirProvisioningMode fromString input String bidirProvisioningMode.
     *
     * @param valInString value of input String
     * @return bidirProvisioningMode
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bidir-provisioning-mode")) {
            return BidirProvisioningMode.class;
        } else if (valInString.equals("bidir-provisioning-single-sided")) {
            return BidirProvisioningSingleSided.class;
        } else if (valInString.equals("bidir-provisioning-double-sided")) {
            return BidirProvisioningDoubleSided.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}