/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

import java.util.Objects;

/**
 * Represents the implementation of percentage.
 */
public final class Percentage {

    private short uint8;

    /**
     * Creates an instance of percentage.
     */
    private Percentage() {
    }

    /**
     * Creates an instance of uint8.
     *
     * @param uint8 value of uint8
     */
    public Percentage(short uint8) {
        this.uint8 = uint8;
    }

    /**
     * Returns the object of percentage for type uint8.
     *
     * @param value value of percentage for type uint8
     * @return percentage for type uint8
     */
    public static Percentage of(short value) {
        return new Percentage(value);
    }

    /**
     * Returns the attribute uint8.
     *
     * @return uint8 value of uint8
     */
    public short uint8() {
        return uint8;
    }
    /**
     * Sets the attribute uint8.
     *
     * @param uint8 value of uint8
     */
    public void uint8(short uint8) {
        this.uint8 = uint8;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint8);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Percentage) {
            Percentage other = (Percentage) obj;
            return
                Objects.deepEquals(uint8, other.uint8);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(uint8);
    }
    /**
     * Returns the object of percentage fromString input String percentage.
     *
     * @param valInString value of input String
     * @return percentage
     */
    public static Percentage fromString(String valInString) {
        try {
            short tmpVal = Short.parseShort(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
