/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehopconfig.type;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehopconfig.Type;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehopconfig.type.asnumber.AsNumberHop;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of asNumber.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAsNumber extends InnerModelObject implements AsNumber {
    protected AsNumberHop asNumberHop;

    @Override
    public AsNumberHop asNumberHop() {
        return asNumberHop;
    }

    @Override
    public void asNumberHop(AsNumberHop asNumberHop) {
        this.asNumberHop = asNumberHop;
    }

    @Override
    public int hashCode() {
        return Objects.hash(asNumberHop);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAsNumber) {
            DefaultAsNumber other = (DefaultAsNumber) obj;
            return
                Objects.deepEquals(asNumberHop, other.asNumberHop);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("asNumberHop=" + asNumberHop)
            .toString();
    }


    /**
     * Creates an instance of defaultAsNumber.
     */
    public DefaultAsNumber() {
    }

}