/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.enumlist;

/**
 * Represents ENUM data of enumleafEnum.
 */
public enum EnumleafEnum {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int enumleafEnum;
    private String schemaName;

    /**
     * Creates an instance of enumleafEnum.
     *
     * @param enumleafEnum value of enumleafEnum
     */
     EnumleafEnum(int enumleafEnum, String schemaName) {
        this.enumleafEnum = enumleafEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of enumleafEnum for.
     *
     * @param value value of enumleafEnum for
     * @return enumleafEnum for
     */
    public static EnumleafEnum of(int value) {
        switch (value) {
            case 10:
                return EnumleafEnum.TEN;
            case 100:
                return EnumleafEnum.HUNDRED;
            case 1000:
                return EnumleafEnum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of enumleafEnum for.
     *
     * @param value value of enumleafEnum for
     * @return enumleafEnum for
     */
    public static EnumleafEnum of(String value) {
        switch (value) {
            case "ten":
                return EnumleafEnum.TEN;
            case "hundred":
                return EnumleafEnum.HUNDRED;
            case "thousand":
                return EnumleafEnum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute enumleafEnum.
     *
     * @return enumleafEnum value of enumleafEnum
     */
    public int enumleafEnum() {
        return enumleafEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
