/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of peDhcp.
 */
public abstract class PeDhcp extends AddressAllocationType {

    /**
     * Returns the attribute pe-dhcp.
     *
     * @return pe-dhcp value of pe-dhcp
     */
    public static String peDhcpToString() {
        return "pe-dhcp";
    }

    /**
     * Returns the object of peDhcp fromString input String peDhcp.
     *
     * @param valInString value of input String
     * @return peDhcp
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("pe-dhcp")) {
            return PeDhcp.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}