/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.vpnservices;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.VpnTopology;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.transportconstraints.TransportConstraints;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnextranet.ExtranetVpns;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.CloudAccesses;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.Multicast;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of vpnSvc.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultVpnSvc extends InnerModelObject 
        implements VpnSvc, MultiInstanceObject<VpnSvcKeys> {
    protected SvcId vpnId;
    protected String customerName;
    protected Class<? extends VpnTopology> topology;
    protected boolean carrierscarrier;
    protected BitSet valueLeafFlags = new BitSet();
    protected CloudAccesses cloudAccesses;
    protected Multicast multicast;
    protected TransportConstraints transportConstraints;
    protected ExtranetVpns extranetVpns;

    @Override
    public SvcId vpnId() {
        return vpnId;
    }

    @Override
    public String customerName() {
        return customerName;
    }

    @Override
    public Class<? extends VpnTopology> topology() {
        return topology;
    }

    @Override
    public boolean carrierscarrier() {
        return carrierscarrier;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public CloudAccesses cloudAccesses() {
        return cloudAccesses;
    }

    @Override
    public Multicast multicast() {
        return multicast;
    }

    @Override
    public TransportConstraints transportConstraints() {
        return transportConstraints;
    }

    @Override
    public ExtranetVpns extranetVpns() {
        return extranetVpns;
    }

    @Override
    public void vpnId(SvcId vpnId) {
        valueLeafFlags.set(LeafIdentifier.VPNID.getLeafIndex());
        this.vpnId = vpnId;
    }

    @Override
    public void customerName(String customerName) {
        valueLeafFlags.set(LeafIdentifier.CUSTOMERNAME.getLeafIndex());
        this.customerName = customerName;
    }

    @Override
    public void topology(Class<? extends VpnTopology> topology) {
        valueLeafFlags.set(LeafIdentifier.TOPOLOGY.getLeafIndex());
        this.topology = topology;
    }

    @Override
    public void carrierscarrier(boolean carrierscarrier) {
        valueLeafFlags.set(LeafIdentifier.CARRIERSCARRIER.getLeafIndex());
        this.carrierscarrier = carrierscarrier;
    }

    @Override
    public void cloudAccesses(CloudAccesses cloudAccesses) {
        this.cloudAccesses = cloudAccesses;
    }

    @Override
    public void multicast(Multicast multicast) {
        this.multicast = multicast;
    }

    @Override
    public void transportConstraints(TransportConstraints transportConstraints) {
        this.transportConstraints = transportConstraints;
    }

    @Override
    public void extranetVpns(ExtranetVpns extranetVpns) {
        this.extranetVpns = extranetVpns;
    }

    @Override
    public int hashCode() {
        return Objects.hash(vpnId, customerName, topology, carrierscarrier, valueLeafFlags, cloudAccesses, multicast, transportConstraints, extranetVpns);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultVpnSvc) {
            DefaultVpnSvc other = (DefaultVpnSvc) obj;
            return
                Objects.deepEquals(vpnId, other.vpnId) &&
                Objects.deepEquals(customerName, other.customerName) &&
                Objects.deepEquals(topology, other.topology) &&
                Objects.deepEquals(carrierscarrier, other.carrierscarrier) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(cloudAccesses, other.cloudAccesses) &&
                Objects.deepEquals(multicast, other.multicast) &&
                Objects.deepEquals(transportConstraints, other.transportConstraints) &&
                Objects.deepEquals(extranetVpns, other.extranetVpns);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("vpnId=" + vpnId)
            .add("customerName=" + customerName)
            .add("topology=" + topology)
            .add("carrierscarrier=" + carrierscarrier)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("cloudAccesses=" + cloudAccesses)
            .add("multicast=" + multicast)
            .add("transportConstraints=" + transportConstraints)
            .add("extranetVpns=" + extranetVpns)
            .toString();
    }


    /**
     * Creates an instance of defaultVpnSvc.
     */
    public DefaultVpnSvc() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}