/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.QosClassificationPolicy;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.QosProfile;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of qos.
 */
public interface Qos extends Augmentable  {

    /**
     * Returns the attribute qosClassificationPolicy.
     *
     * @return qosClassificationPolicy value of qosClassificationPolicy
     */
    QosClassificationPolicy qosClassificationPolicy();

    /**
     * Returns the attribute qosProfile.
     *
     * @return qosProfile value of qosProfile
     */
    QosProfile qosProfile();

    /**
     * Sets the attribute qosClassificationPolicy.
     *
     * @param qosClassificationPolicy value of qosClassificationPolicy
     */
    void qosClassificationPolicy(QosClassificationPolicy qosClassificationPolicy);

    /**
     * Sets the attribute qosProfile.
     *
     * @param qosProfile value of qosProfile
     */
    void qosProfile(QosProfile qosProfile);

}