/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.CloudAccess;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cloudAccesses.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCloudAccesses extends InnerModelObject implements CloudAccesses {
    protected List<CloudAccess> cloudAccess;

    @Override
    public List<CloudAccess> cloudAccess() {
        return cloudAccess;
    }

    @Override
    public void cloudAccess(List<CloudAccess> cloudAccess) {
        this.cloudAccess = cloudAccess;
    }

    @Override
    public void addToCloudAccess(CloudAccess addTo) {
        if (cloudAccess == null) {
            cloudAccess = new ArrayList<>();
        }
        cloudAccess.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(cloudAccess);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCloudAccesses) {
            DefaultCloudAccesses other = (DefaultCloudAccesses) obj;
            return
                Objects.deepEquals(cloudAccess, other.cloudAccess);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cloudAccess=" + cloudAccess)
            .toString();
    }


    /**
     * Creates an instance of defaultCloudAccesses.
     */
    public DefaultCloudAccesses() {
    }

}