/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Con1;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf1Union;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.type.Leaf6Enum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of type.
 */
public interface Type extends Augmentable  {

    /**
     * Identify the leaf of Type.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1.
         */
        LEAF1(1),
        /**
         * Represents leaf2.
         */
        LEAF2(2),
        /**
         * Represents leaf3.
         */
        LEAF3(3),
        /**
         * Represents leaf4.
         */
        LEAF4(4),
        /**
         * Represents leaf5.
         */
        LEAF5(5),
        /**
         * Represents leaf6.
         */
        LEAF6(6),
        /**
         * Represents leaf7.
         */
        LEAF7(7),
        /**
         * Represents leaf8.
         */
        LEAF8(8),
        /**
         * Represents leaf9.
         */
        LEAF9(9);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    Leaf1Union leaf1();

    /**
     * Returns the attribute leaf2.
     *
     * @return leaf2 value of leaf2
     */
    Class<? extends YangAutoPrefixInt> leaf2();

    /**
     * Returns the attribute leaf3.
     *
     * @return leaf3 value of leaf3
     */
    Tdef1 leaf3();

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 value of leaf4
     */
    Class<? extends YangAutoPrefixInt> leaf4();

    /**
     * Returns the attribute leaf5.
     *
     * @return leaf5 value of leaf5
     */
    String leaf5();

    /**
     * Returns the attribute leaf6.
     *
     * @return leaf6 value of leaf6
     */
    Leaf6Enum leaf6();

    /**
     * Returns the attribute leaf7.
     *
     * @return leaf7 value of leaf7
     */
    Bitdef leaf7();

    /**
     * Returns the attribute leaf8.
     *
     * @return leaf8 value of leaf8
     */
    byte[] leaf8();

    /**
     * Returns the attribute leaf9.
     *
     * @return leaf9 value of leaf9
     */
    Id leaf9();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute con1.
     *
     * @return con1 value of con1
     */
    Con1 con1();

    /**
     * Sets the attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    void leaf1(Leaf1Union leaf1);

    /**
     * Sets the attribute leaf2.
     *
     * @param leaf2 value of leaf2
     */
    void leaf2(Class<? extends YangAutoPrefixInt> leaf2);

    /**
     * Sets the attribute leaf3.
     *
     * @param leaf3 value of leaf3
     */
    void leaf3(Tdef1 leaf3);

    /**
     * Sets the attribute leaf4.
     *
     * @param leaf4 value of leaf4
     */
    void leaf4(Class<? extends YangAutoPrefixInt> leaf4);

    /**
     * Sets the attribute leaf5.
     *
     * @param leaf5 value of leaf5
     */
    void leaf5(String leaf5);

    /**
     * Sets the attribute leaf6.
     *
     * @param leaf6 value of leaf6
     */
    void leaf6(Leaf6Enum leaf6);

    /**
     * Sets the attribute leaf7.
     *
     * @param leaf7 value of leaf7
     */
    void leaf7(Bitdef leaf7);

    /**
     * Sets the attribute leaf8.
     *
     * @param leaf8 value of leaf8
     */
    void leaf8(byte[] leaf8);

    /**
     * Sets the attribute leaf9.
     *
     * @param leaf9 value of leaf9
     */
    void leaf9(Id leaf9);

    /**
     * Sets the attribute con1.
     *
     * @param con1 value of con1
     */
    void con1(Con1 con1);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}