/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.gr;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.Iden;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont3.
 */
public interface Cont3 extends Augmentable  {

    /**
     * Identify the leaf of Cont3.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents lref21.
         */
        LREF21(1),
        /**
         * Represents iref1.
         */
        IREF1(2),
        /**
         * Represents iref3.
         */
        IREF3(3),
        /**
         * Represents llref1.
         */
        LLREF1(4),
        /**
         * Represents llref2.
         */
        LLREF2(5),
        /**
         * Represents llref3.
         */
        LLREF3(6),
        /**
         * Represents llref4.
         */
        LLREF4(7),
        /**
         * Represents llref5.
         */
        LLREF5(8),
        /**
         * Represents llref6.
         */
        LLREF6(9),
        /**
         * Represents llref7.
         */
        LLREF7(10),
        /**
         * Represents llref8.
         */
        LLREF8(11),
        /**
         * Represents llref9.
         */
        LLREF9(12),
        /**
         * Represents llref10.
         */
        LLREF10(13),
        /**
         * Represents llref11.
         */
        LLREF11(14),
        /**
         * Represents llref12.
         */
        LLREF12(15),
        /**
         * Represents llref13.
         */
        LLREF13(16),
        /**
         * Represents llref14.
         */
        LLREF14(17),
        /**
         * Represents llref15.
         */
        LLREF15(18),
        /**
         * Represents llref16.
         */
        LLREF16(19),
        /**
         * Represents llref17.
         */
        LLREF17(20),
        /**
         * Represents llref18.
         */
        LLREF18(21),
        /**
         * Represents llref19.
         */
        LLREF19(22),
        /**
         * Represents llref20.
         */
        LLREF20(23),
        /**
         * Represents iref2.
         */
        IREF2(24),
        /**
         * Represents iref4.
         */
        IREF4(25);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute lref21.
     *
     * @return lref21 value of lref21
     */
    Object lref21();

    /**
     * Returns the attribute iref1.
     *
     * @return iref1 value of iref1
     */
    Class<? extends Iden> iref1();

    /**
     * Returns the attribute iref3.
     *
     * @return iref3 value of iref3
     */
    Class<? extends Type> iref3();

    /**
     * Returns the attribute llref1.
     *
     * @return llref1 list of llref1
     */
    List<Object> llref1();

    /**
     * Returns the attribute llref2.
     *
     * @return llref2 list of llref2
     */
    List<Object> llref2();

    /**
     * Returns the attribute llref3.
     *
     * @return llref3 list of llref3
     */
    List<Object> llref3();

    /**
     * Returns the attribute llref4.
     *
     * @return llref4 list of llref4
     */
    List<Object> llref4();

    /**
     * Returns the attribute llref5.
     *
     * @return llref5 list of llref5
     */
    List<Object> llref5();

    /**
     * Returns the attribute llref6.
     *
     * @return llref6 list of llref6
     */
    List<Object> llref6();

    /**
     * Returns the attribute llref7.
     *
     * @return llref7 list of llref7
     */
    List<Object> llref7();

    /**
     * Returns the attribute llref8.
     *
     * @return llref8 list of llref8
     */
    List<Object> llref8();

    /**
     * Returns the attribute llref9.
     *
     * @return llref9 list of llref9
     */
    List<Object> llref9();

    /**
     * Returns the attribute llref10.
     *
     * @return llref10 list of llref10
     */
    List<Object> llref10();

    /**
     * Returns the attribute llref11.
     *
     * @return llref11 list of llref11
     */
    List<Object> llref11();

    /**
     * Returns the attribute llref12.
     *
     * @return llref12 list of llref12
     */
    List<Object> llref12();

    /**
     * Returns the attribute llref13.
     *
     * @return llref13 list of llref13
     */
    List<Object> llref13();

    /**
     * Returns the attribute llref14.
     *
     * @return llref14 list of llref14
     */
    List<Object> llref14();

    /**
     * Returns the attribute llref15.
     *
     * @return llref15 list of llref15
     */
    List<Object> llref15();

    /**
     * Returns the attribute llref16.
     *
     * @return llref16 list of llref16
     */
    List<Object> llref16();

    /**
     * Returns the attribute llref17.
     *
     * @return llref17 list of llref17
     */
    List<Object> llref17();

    /**
     * Returns the attribute llref18.
     *
     * @return llref18 list of llref18
     */
    List<Object> llref18();

    /**
     * Returns the attribute llref19.
     *
     * @return llref19 list of llref19
     */
    List<Object> llref19();

    /**
     * Returns the attribute llref20.
     *
     * @return llref20 list of llref20
     */
    List<Object> llref20();

    /**
     * Returns the attribute iref2.
     *
     * @return iref2 list of iref2
     */
    List<Class<? extends Iden>> iref2();

    /**
     * Returns the attribute iref4.
     *
     * @return iref4 list of iref4
     */
    List<Class<? extends Type>> iref4();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute lref21.
     *
     * @param lref21 value of lref21
     */
    void lref21(Object lref21);

    /**
     * Sets the attribute iref1.
     *
     * @param iref1 value of iref1
     */
    void iref1(Class<? extends Iden> iref1);

    /**
     * Sets the attribute iref3.
     *
     * @param iref3 value of iref3
     */
    void iref3(Class<? extends Type> iref3);

    /**
     * Sets the attribute llref1.
     *
     * @param llref1 list of llref1
     */
    void llref1(List<Object> llref1);

    /**
     * Sets the attribute llref2.
     *
     * @param llref2 list of llref2
     */
    void llref2(List<Object> llref2);

    /**
     * Sets the attribute llref3.
     *
     * @param llref3 list of llref3
     */
    void llref3(List<Object> llref3);

    /**
     * Sets the attribute llref4.
     *
     * @param llref4 list of llref4
     */
    void llref4(List<Object> llref4);

    /**
     * Sets the attribute llref5.
     *
     * @param llref5 list of llref5
     */
    void llref5(List<Object> llref5);

    /**
     * Sets the attribute llref6.
     *
     * @param llref6 list of llref6
     */
    void llref6(List<Object> llref6);

    /**
     * Sets the attribute llref7.
     *
     * @param llref7 list of llref7
     */
    void llref7(List<Object> llref7);

    /**
     * Sets the attribute llref8.
     *
     * @param llref8 list of llref8
     */
    void llref8(List<Object> llref8);

    /**
     * Sets the attribute llref9.
     *
     * @param llref9 list of llref9
     */
    void llref9(List<Object> llref9);

    /**
     * Sets the attribute llref10.
     *
     * @param llref10 list of llref10
     */
    void llref10(List<Object> llref10);

    /**
     * Sets the attribute llref11.
     *
     * @param llref11 list of llref11
     */
    void llref11(List<Object> llref11);

    /**
     * Sets the attribute llref12.
     *
     * @param llref12 list of llref12
     */
    void llref12(List<Object> llref12);

    /**
     * Sets the attribute llref13.
     *
     * @param llref13 list of llref13
     */
    void llref13(List<Object> llref13);

    /**
     * Sets the attribute llref14.
     *
     * @param llref14 list of llref14
     */
    void llref14(List<Object> llref14);

    /**
     * Sets the attribute llref15.
     *
     * @param llref15 list of llref15
     */
    void llref15(List<Object> llref15);

    /**
     * Sets the attribute llref16.
     *
     * @param llref16 list of llref16
     */
    void llref16(List<Object> llref16);

    /**
     * Sets the attribute llref17.
     *
     * @param llref17 list of llref17
     */
    void llref17(List<Object> llref17);

    /**
     * Sets the attribute llref18.
     *
     * @param llref18 list of llref18
     */
    void llref18(List<Object> llref18);

    /**
     * Sets the attribute llref19.
     *
     * @param llref19 list of llref19
     */
    void llref19(List<Object> llref19);

    /**
     * Sets the attribute llref20.
     *
     * @param llref20 list of llref20
     */
    void llref20(List<Object> llref20);

    /**
     * Sets the attribute iref2.
     *
     * @param iref2 list of iref2
     */
    void iref2(List<Class<? extends Iden>> iref2);

    /**
     * Sets the attribute iref4.
     *
     * @param iref4 list of iref4
     */
    void iref4(List<Class<? extends Type>> iref4);

    /**
     * Adds to the list of llref1.
     *
     * @param addTo value of llref1
     */
    void addToLlref1(Object addTo);

    /**
     * Adds to the list of llref2.
     *
     * @param addTo value of llref2
     */
    void addToLlref2(Object addTo);

    /**
     * Adds to the list of llref3.
     *
     * @param addTo value of llref3
     */
    void addToLlref3(Object addTo);

    /**
     * Adds to the list of llref4.
     *
     * @param addTo value of llref4
     */
    void addToLlref4(Object addTo);

    /**
     * Adds to the list of llref5.
     *
     * @param addTo value of llref5
     */
    void addToLlref5(Object addTo);

    /**
     * Adds to the list of llref6.
     *
     * @param addTo value of llref6
     */
    void addToLlref6(Object addTo);

    /**
     * Adds to the list of llref7.
     *
     * @param addTo value of llref7
     */
    void addToLlref7(Object addTo);

    /**
     * Adds to the list of llref8.
     *
     * @param addTo value of llref8
     */
    void addToLlref8(Object addTo);

    /**
     * Adds to the list of llref9.
     *
     * @param addTo value of llref9
     */
    void addToLlref9(Object addTo);

    /**
     * Adds to the list of llref10.
     *
     * @param addTo value of llref10
     */
    void addToLlref10(Object addTo);

    /**
     * Adds to the list of llref11.
     *
     * @param addTo value of llref11
     */
    void addToLlref11(Object addTo);

    /**
     * Adds to the list of llref12.
     *
     * @param addTo value of llref12
     */
    void addToLlref12(Object addTo);

    /**
     * Adds to the list of llref13.
     *
     * @param addTo value of llref13
     */
    void addToLlref13(Object addTo);

    /**
     * Adds to the list of llref14.
     *
     * @param addTo value of llref14
     */
    void addToLlref14(Object addTo);

    /**
     * Adds to the list of llref15.
     *
     * @param addTo value of llref15
     */
    void addToLlref15(Object addTo);

    /**
     * Adds to the list of llref16.
     *
     * @param addTo value of llref16
     */
    void addToLlref16(Object addTo);

    /**
     * Adds to the list of llref17.
     *
     * @param addTo value of llref17
     */
    void addToLlref17(Object addTo);

    /**
     * Adds to the list of llref18.
     *
     * @param addTo value of llref18
     */
    void addToLlref18(Object addTo);

    /**
     * Adds to the list of llref19.
     *
     * @param addTo value of llref19
     */
    void addToLlref19(Object addTo);

    /**
     * Adds to the list of llref20.
     *
     * @param addTo value of llref20
     */
    void addToLlref20(Object addTo);

    /**
     * Adds to the list of iref2.
     *
     * @param addTo value of iref2
     */
    void addToIref2(Class<? extends Iden> addTo);

    /**
     * Adds to the list of iref4.
     *
     * @param addTo value of iref4
     */
    void addToIref4(Class<? extends Type> addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}