/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfenum1Enum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfenum2Enum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.LfenumEnum;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion10Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion11Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion14Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion1Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion2Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion4Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion5Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion8Union;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1.Lfunion9Union;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont1.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont1 extends InnerModelObject implements Cont1 {
    protected List<Byte> lfnint8Min;
    protected List<Byte> lfnint8Max;
    protected List<Short> lfnint16Min;
    protected List<Short> lfnint16Max;
    protected List<Integer> lfnint32Min;
    protected List<Integer> lfnint32Max;
    protected List<Long> lfnint64Min;
    protected List<Long> lfnint64Max;
    protected List<Short> lfnuint8Max;
    protected List<Integer> lfnuint16Max;
    protected List<Long> lfnuint32Max;
    protected List<BigInteger> lfuint64Max;
    protected List<String> lfstr;
    protected List<String> lfstr1;
    protected List<Boolean> lfbool1;
    protected List<Boolean> lfbool2;
    protected List<Boolean> lfbool3;
    protected List<BigDecimal> lfdecimal1;
    protected List<BigDecimal> lfdecimal2;
    protected List<BigDecimal> lfdecimal3;
    protected List<BigDecimal> lfdecimal4;
    protected List<BigDecimal> lfdecimal6;
    protected List<LfenumEnum> lfenum;
    protected List<BitSet> lfbits;
    protected List<byte[]> lfbinary;
    protected List<String> lfref1;
    protected List<Byte> lfref2;
    protected List<Boolean> lfempty;
    protected List<Lfunion1Union> lfunion1;
    protected List<Lfunion2Union> lfunion2;
    protected List<Lfunion4Union> lfunion4;
    protected List<Lfunion5Union> lfunion5;
    protected List<Tpdfun3> lfunion7;
    protected List<Lfunion8Union> lfunion8;
    protected List<Lfunion9Union> lfunion9;
    protected List<Lfunion10Union> lfunion10;
    protected List<Lfunion11Union> lfunion11;
    protected List<Tpdfun2> lfunion12;
    protected List<Tpdfbit> lfunion13;
    protected List<Lfunion14Union> lfunion14;
    protected List<Class<? extends Iden>> identityref1;
    protected List<Lfenum1Enum> lfenum1;
    protected List<Lfenum2Enum> lfenum2;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<Byte> lfnint8Min() {
        return lfnint8Min;
    }

    @Override
    public List<Byte> lfnint8Max() {
        return lfnint8Max;
    }

    @Override
    public List<Short> lfnint16Min() {
        return lfnint16Min;
    }

    @Override
    public List<Short> lfnint16Max() {
        return lfnint16Max;
    }

    @Override
    public List<Integer> lfnint32Min() {
        return lfnint32Min;
    }

    @Override
    public List<Integer> lfnint32Max() {
        return lfnint32Max;
    }

    @Override
    public List<Long> lfnint64Min() {
        return lfnint64Min;
    }

    @Override
    public List<Long> lfnint64Max() {
        return lfnint64Max;
    }

    @Override
    public List<Short> lfnuint8Max() {
        return lfnuint8Max;
    }

    @Override
    public List<Integer> lfnuint16Max() {
        return lfnuint16Max;
    }

    @Override
    public List<Long> lfnuint32Max() {
        return lfnuint32Max;
    }

    @Override
    public List<BigInteger> lfuint64Max() {
        return lfuint64Max;
    }

    @Override
    public List<String> lfstr() {
        return lfstr;
    }

    @Override
    public List<String> lfstr1() {
        return lfstr1;
    }

    @Override
    public List<Boolean> lfbool1() {
        return lfbool1;
    }

    @Override
    public List<Boolean> lfbool2() {
        return lfbool2;
    }

    @Override
    public List<Boolean> lfbool3() {
        return lfbool3;
    }

    @Override
    public List<BigDecimal> lfdecimal1() {
        return lfdecimal1;
    }

    @Override
    public List<BigDecimal> lfdecimal2() {
        return lfdecimal2;
    }

    @Override
    public List<BigDecimal> lfdecimal3() {
        return lfdecimal3;
    }

    @Override
    public List<BigDecimal> lfdecimal4() {
        return lfdecimal4;
    }

    @Override
    public List<BigDecimal> lfdecimal6() {
        return lfdecimal6;
    }

    @Override
    public List<LfenumEnum> lfenum() {
        return lfenum;
    }

    @Override
    public List<BitSet> lfbits() {
        return lfbits;
    }

    @Override
    public List<byte[]> lfbinary() {
        return lfbinary;
    }

    @Override
    public List<String> lfref1() {
        return lfref1;
    }

    @Override
    public List<Byte> lfref2() {
        return lfref2;
    }

    @Override
    public List<Boolean> lfempty() {
        return lfempty;
    }

    @Override
    public List<Lfunion1Union> lfunion1() {
        return lfunion1;
    }

    @Override
    public List<Lfunion2Union> lfunion2() {
        return lfunion2;
    }

    @Override
    public List<Lfunion4Union> lfunion4() {
        return lfunion4;
    }

    @Override
    public List<Lfunion5Union> lfunion5() {
        return lfunion5;
    }

    @Override
    public List<Tpdfun3> lfunion7() {
        return lfunion7;
    }

    @Override
    public List<Lfunion8Union> lfunion8() {
        return lfunion8;
    }

    @Override
    public List<Lfunion9Union> lfunion9() {
        return lfunion9;
    }

    @Override
    public List<Lfunion10Union> lfunion10() {
        return lfunion10;
    }

    @Override
    public List<Lfunion11Union> lfunion11() {
        return lfunion11;
    }

    @Override
    public List<Tpdfun2> lfunion12() {
        return lfunion12;
    }

    @Override
    public List<Tpdfbit> lfunion13() {
        return lfunion13;
    }

    @Override
    public List<Lfunion14Union> lfunion14() {
        return lfunion14;
    }

    @Override
    public List<Class<? extends Iden>> identityref1() {
        return identityref1;
    }

    @Override
    public List<Lfenum1Enum> lfenum1() {
        return lfenum1;
    }

    @Override
    public List<Lfenum2Enum> lfenum2() {
        return lfenum2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lfnint8Min(List<Byte> lfnint8Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT8MIN.getLeafIndex());
        this.lfnint8Min = lfnint8Min;
    }

    @Override
    public void lfnint8Max(List<Byte> lfnint8Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT8MAX.getLeafIndex());
        this.lfnint8Max = lfnint8Max;
    }

    @Override
    public void lfnint16Min(List<Short> lfnint16Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT16MIN.getLeafIndex());
        this.lfnint16Min = lfnint16Min;
    }

    @Override
    public void lfnint16Max(List<Short> lfnint16Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT16MAX.getLeafIndex());
        this.lfnint16Max = lfnint16Max;
    }

    @Override
    public void lfnint32Min(List<Integer> lfnint32Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT32MIN.getLeafIndex());
        this.lfnint32Min = lfnint32Min;
    }

    @Override
    public void lfnint32Max(List<Integer> lfnint32Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT32MAX.getLeafIndex());
        this.lfnint32Max = lfnint32Max;
    }

    @Override
    public void lfnint64Min(List<Long> lfnint64Min) {
        valueLeafFlags.set(LeafIdentifier.LFNINT64MIN.getLeafIndex());
        this.lfnint64Min = lfnint64Min;
    }

    @Override
    public void lfnint64Max(List<Long> lfnint64Max) {
        valueLeafFlags.set(LeafIdentifier.LFNINT64MAX.getLeafIndex());
        this.lfnint64Max = lfnint64Max;
    }

    @Override
    public void lfnuint8Max(List<Short> lfnuint8Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT8MAX.getLeafIndex());
        this.lfnuint8Max = lfnuint8Max;
    }

    @Override
    public void lfnuint16Max(List<Integer> lfnuint16Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT16MAX.getLeafIndex());
        this.lfnuint16Max = lfnuint16Max;
    }

    @Override
    public void lfnuint32Max(List<Long> lfnuint32Max) {
        valueLeafFlags.set(LeafIdentifier.LFNUINT32MAX.getLeafIndex());
        this.lfnuint32Max = lfnuint32Max;
    }

    @Override
    public void lfuint64Max(List<BigInteger> lfuint64Max) {
        valueLeafFlags.set(LeafIdentifier.LFUINT64MAX.getLeafIndex());
        this.lfuint64Max = lfuint64Max;
    }

    @Override
    public void lfstr(List<String> lfstr) {
        valueLeafFlags.set(LeafIdentifier.LFSTR.getLeafIndex());
        this.lfstr = lfstr;
    }

    @Override
    public void lfstr1(List<String> lfstr1) {
        valueLeafFlags.set(LeafIdentifier.LFSTR1.getLeafIndex());
        this.lfstr1 = lfstr1;
    }

    @Override
    public void lfbool1(List<Boolean> lfbool1) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL1.getLeafIndex());
        this.lfbool1 = lfbool1;
    }

    @Override
    public void lfbool2(List<Boolean> lfbool2) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL2.getLeafIndex());
        this.lfbool2 = lfbool2;
    }

    @Override
    public void lfbool3(List<Boolean> lfbool3) {
        valueLeafFlags.set(LeafIdentifier.LFBOOL3.getLeafIndex());
        this.lfbool3 = lfbool3;
    }

    @Override
    public void lfdecimal1(List<BigDecimal> lfdecimal1) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL1.getLeafIndex());
        this.lfdecimal1 = lfdecimal1;
    }

    @Override
    public void lfdecimal2(List<BigDecimal> lfdecimal2) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL2.getLeafIndex());
        this.lfdecimal2 = lfdecimal2;
    }

    @Override
    public void lfdecimal3(List<BigDecimal> lfdecimal3) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL3.getLeafIndex());
        this.lfdecimal3 = lfdecimal3;
    }

    @Override
    public void lfdecimal4(List<BigDecimal> lfdecimal4) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL4.getLeafIndex());
        this.lfdecimal4 = lfdecimal4;
    }

    @Override
    public void lfdecimal6(List<BigDecimal> lfdecimal6) {
        valueLeafFlags.set(LeafIdentifier.LFDECIMAL6.getLeafIndex());
        this.lfdecimal6 = lfdecimal6;
    }

    @Override
    public void lfenum(List<LfenumEnum> lfenum) {
        valueLeafFlags.set(LeafIdentifier.LFENUM.getLeafIndex());
        this.lfenum = lfenum;
    }

    @Override
    public void lfbits(List<BitSet> lfbits) {
        valueLeafFlags.set(LeafIdentifier.LFBITS.getLeafIndex());
        this.lfbits = lfbits;
    }

    @Override
    public void lfbinary(List<byte[]> lfbinary) {
        valueLeafFlags.set(LeafIdentifier.LFBINARY.getLeafIndex());
        this.lfbinary = lfbinary;
    }

    @Override
    public void lfref1(List<String> lfref1) {
        valueLeafFlags.set(LeafIdentifier.LFREF1.getLeafIndex());
        this.lfref1 = lfref1;
    }

    @Override
    public void lfref2(List<Byte> lfref2) {
        valueLeafFlags.set(LeafIdentifier.LFREF2.getLeafIndex());
        this.lfref2 = lfref2;
    }

    @Override
    public void lfempty(List<Boolean> lfempty) {
        valueLeafFlags.set(LeafIdentifier.LFEMPTY.getLeafIndex());
        this.lfempty = lfempty;
    }

    @Override
    public void lfunion1(List<Lfunion1Union> lfunion1) {
        valueLeafFlags.set(LeafIdentifier.LFUNION1.getLeafIndex());
        this.lfunion1 = lfunion1;
    }

    @Override
    public void lfunion2(List<Lfunion2Union> lfunion2) {
        valueLeafFlags.set(LeafIdentifier.LFUNION2.getLeafIndex());
        this.lfunion2 = lfunion2;
    }

    @Override
    public void lfunion4(List<Lfunion4Union> lfunion4) {
        valueLeafFlags.set(LeafIdentifier.LFUNION4.getLeafIndex());
        this.lfunion4 = lfunion4;
    }

    @Override
    public void lfunion5(List<Lfunion5Union> lfunion5) {
        valueLeafFlags.set(LeafIdentifier.LFUNION5.getLeafIndex());
        this.lfunion5 = lfunion5;
    }

    @Override
    public void lfunion7(List<Tpdfun3> lfunion7) {
        valueLeafFlags.set(LeafIdentifier.LFUNION7.getLeafIndex());
        this.lfunion7 = lfunion7;
    }

    @Override
    public void lfunion8(List<Lfunion8Union> lfunion8) {
        valueLeafFlags.set(LeafIdentifier.LFUNION8.getLeafIndex());
        this.lfunion8 = lfunion8;
    }

    @Override
    public void lfunion9(List<Lfunion9Union> lfunion9) {
        valueLeafFlags.set(LeafIdentifier.LFUNION9.getLeafIndex());
        this.lfunion9 = lfunion9;
    }

    @Override
    public void lfunion10(List<Lfunion10Union> lfunion10) {
        valueLeafFlags.set(LeafIdentifier.LFUNION10.getLeafIndex());
        this.lfunion10 = lfunion10;
    }

    @Override
    public void lfunion11(List<Lfunion11Union> lfunion11) {
        valueLeafFlags.set(LeafIdentifier.LFUNION11.getLeafIndex());
        this.lfunion11 = lfunion11;
    }

    @Override
    public void lfunion12(List<Tpdfun2> lfunion12) {
        valueLeafFlags.set(LeafIdentifier.LFUNION12.getLeafIndex());
        this.lfunion12 = lfunion12;
    }

    @Override
    public void lfunion13(List<Tpdfbit> lfunion13) {
        valueLeafFlags.set(LeafIdentifier.LFUNION13.getLeafIndex());
        this.lfunion13 = lfunion13;
    }

    @Override
    public void lfunion14(List<Lfunion14Union> lfunion14) {
        valueLeafFlags.set(LeafIdentifier.LFUNION14.getLeafIndex());
        this.lfunion14 = lfunion14;
    }

    @Override
    public void identityref1(List<Class<? extends Iden>> identityref1) {
        valueLeafFlags.set(LeafIdentifier.IDENTITYREF1.getLeafIndex());
        this.identityref1 = identityref1;
    }

    @Override
    public void lfenum1(List<Lfenum1Enum> lfenum1) {
        valueLeafFlags.set(LeafIdentifier.LFENUM1.getLeafIndex());
        this.lfenum1 = lfenum1;
    }

    @Override
    public void lfenum2(List<Lfenum2Enum> lfenum2) {
        valueLeafFlags.set(LeafIdentifier.LFENUM2.getLeafIndex());
        this.lfenum2 = lfenum2;
    }

    @Override
    public void addToLfnint8Min(Byte addTo) {
        if (lfnint8Min == null) {
            lfnint8Min = new ArrayList<>();
        }
        lfnint8Min.add(addTo);
    }


    @Override
    public void addToLfnint8Max(Byte addTo) {
        if (lfnint8Max == null) {
            lfnint8Max = new ArrayList<>();
        }
        lfnint8Max.add(addTo);
    }


    @Override
    public void addToLfnint16Min(Short addTo) {
        if (lfnint16Min == null) {
            lfnint16Min = new ArrayList<>();
        }
        lfnint16Min.add(addTo);
    }


    @Override
    public void addToLfnint16Max(Short addTo) {
        if (lfnint16Max == null) {
            lfnint16Max = new ArrayList<>();
        }
        lfnint16Max.add(addTo);
    }


    @Override
    public void addToLfnint32Min(Integer addTo) {
        if (lfnint32Min == null) {
            lfnint32Min = new ArrayList<>();
        }
        lfnint32Min.add(addTo);
    }


    @Override
    public void addToLfnint32Max(Integer addTo) {
        if (lfnint32Max == null) {
            lfnint32Max = new ArrayList<>();
        }
        lfnint32Max.add(addTo);
    }


    @Override
    public void addToLfnint64Min(Long addTo) {
        if (lfnint64Min == null) {
            lfnint64Min = new ArrayList<>();
        }
        lfnint64Min.add(addTo);
    }


    @Override
    public void addToLfnint64Max(Long addTo) {
        if (lfnint64Max == null) {
            lfnint64Max = new ArrayList<>();
        }
        lfnint64Max.add(addTo);
    }


    @Override
    public void addToLfnuint8Max(Short addTo) {
        if (lfnuint8Max == null) {
            lfnuint8Max = new ArrayList<>();
        }
        lfnuint8Max.add(addTo);
    }


    @Override
    public void addToLfnuint16Max(Integer addTo) {
        if (lfnuint16Max == null) {
            lfnuint16Max = new ArrayList<>();
        }
        lfnuint16Max.add(addTo);
    }


    @Override
    public void addToLfnuint32Max(Long addTo) {
        if (lfnuint32Max == null) {
            lfnuint32Max = new ArrayList<>();
        }
        lfnuint32Max.add(addTo);
    }


    @Override
    public void addToLfuint64Max(BigInteger addTo) {
        if (lfuint64Max == null) {
            lfuint64Max = new ArrayList<>();
        }
        lfuint64Max.add(addTo);
    }


    @Override
    public void addToLfstr(String addTo) {
        if (lfstr == null) {
            lfstr = new ArrayList<>();
        }
        lfstr.add(addTo);
    }


    @Override
    public void addToLfstr1(String addTo) {
        if (lfstr1 == null) {
            lfstr1 = new ArrayList<>();
        }
        lfstr1.add(addTo);
    }


    @Override
    public void addToLfbool1(Boolean addTo) {
        if (lfbool1 == null) {
            lfbool1 = new ArrayList<>();
        }
        lfbool1.add(addTo);
    }


    @Override
    public void addToLfbool2(Boolean addTo) {
        if (lfbool2 == null) {
            lfbool2 = new ArrayList<>();
        }
        lfbool2.add(addTo);
    }


    @Override
    public void addToLfbool3(Boolean addTo) {
        if (lfbool3 == null) {
            lfbool3 = new ArrayList<>();
        }
        lfbool3.add(addTo);
    }


    @Override
    public void addToLfdecimal1(BigDecimal addTo) {
        if (lfdecimal1 == null) {
            lfdecimal1 = new ArrayList<>();
        }
        lfdecimal1.add(addTo);
    }


    @Override
    public void addToLfdecimal2(BigDecimal addTo) {
        if (lfdecimal2 == null) {
            lfdecimal2 = new ArrayList<>();
        }
        lfdecimal2.add(addTo);
    }


    @Override
    public void addToLfdecimal3(BigDecimal addTo) {
        if (lfdecimal3 == null) {
            lfdecimal3 = new ArrayList<>();
        }
        lfdecimal3.add(addTo);
    }


    @Override
    public void addToLfdecimal4(BigDecimal addTo) {
        if (lfdecimal4 == null) {
            lfdecimal4 = new ArrayList<>();
        }
        lfdecimal4.add(addTo);
    }


    @Override
    public void addToLfdecimal6(BigDecimal addTo) {
        if (lfdecimal6 == null) {
            lfdecimal6 = new ArrayList<>();
        }
        lfdecimal6.add(addTo);
    }


    @Override
    public void addToLfenum(LfenumEnum addTo) {
        if (lfenum == null) {
            lfenum = new ArrayList<>();
        }
        lfenum.add(addTo);
    }


    @Override
    public void addToLfbits(BitSet addTo) {
        if (lfbits == null) {
            lfbits = new ArrayList<>();
        }
        lfbits.add(addTo);
    }


    @Override
    public void addToLfbinary(byte[] addTo) {
        if (lfbinary == null) {
            lfbinary = new ArrayList<>();
        }
        lfbinary.add(addTo);
    }


    @Override
    public void addToLfref1(String addTo) {
        if (lfref1 == null) {
            lfref1 = new ArrayList<>();
        }
        lfref1.add(addTo);
    }


    @Override
    public void addToLfref2(Byte addTo) {
        if (lfref2 == null) {
            lfref2 = new ArrayList<>();
        }
        lfref2.add(addTo);
    }


    @Override
    public void addToLfempty(Boolean addTo) {
        if (lfempty == null) {
            lfempty = new ArrayList<>();
        }
        lfempty.add(addTo);
    }


    @Override
    public void addToLfunion1(Lfunion1Union addTo) {
        if (lfunion1 == null) {
            lfunion1 = new ArrayList<>();
        }
        lfunion1.add(addTo);
    }


    @Override
    public void addToLfunion2(Lfunion2Union addTo) {
        if (lfunion2 == null) {
            lfunion2 = new ArrayList<>();
        }
        lfunion2.add(addTo);
    }


    @Override
    public void addToLfunion4(Lfunion4Union addTo) {
        if (lfunion4 == null) {
            lfunion4 = new ArrayList<>();
        }
        lfunion4.add(addTo);
    }


    @Override
    public void addToLfunion5(Lfunion5Union addTo) {
        if (lfunion5 == null) {
            lfunion5 = new ArrayList<>();
        }
        lfunion5.add(addTo);
    }


    @Override
    public void addToLfunion7(Tpdfun3 addTo) {
        if (lfunion7 == null) {
            lfunion7 = new ArrayList<>();
        }
        lfunion7.add(addTo);
    }


    @Override
    public void addToLfunion8(Lfunion8Union addTo) {
        if (lfunion8 == null) {
            lfunion8 = new ArrayList<>();
        }
        lfunion8.add(addTo);
    }


    @Override
    public void addToLfunion9(Lfunion9Union addTo) {
        if (lfunion9 == null) {
            lfunion9 = new ArrayList<>();
        }
        lfunion9.add(addTo);
    }


    @Override
    public void addToLfunion10(Lfunion10Union addTo) {
        if (lfunion10 == null) {
            lfunion10 = new ArrayList<>();
        }
        lfunion10.add(addTo);
    }


    @Override
    public void addToLfunion11(Lfunion11Union addTo) {
        if (lfunion11 == null) {
            lfunion11 = new ArrayList<>();
        }
        lfunion11.add(addTo);
    }


    @Override
    public void addToLfunion12(Tpdfun2 addTo) {
        if (lfunion12 == null) {
            lfunion12 = new ArrayList<>();
        }
        lfunion12.add(addTo);
    }


    @Override
    public void addToLfunion13(Tpdfbit addTo) {
        if (lfunion13 == null) {
            lfunion13 = new ArrayList<>();
        }
        lfunion13.add(addTo);
    }


    @Override
    public void addToLfunion14(Lfunion14Union addTo) {
        if (lfunion14 == null) {
            lfunion14 = new ArrayList<>();
        }
        lfunion14.add(addTo);
    }


    @Override
    public void addToIdentityref1(Class<? extends Iden> addTo) {
        if (identityref1 == null) {
            identityref1 = new ArrayList<>();
        }
        identityref1.add(addTo);
    }


    @Override
    public void addToLfenum1(Lfenum1Enum addTo) {
        if (lfenum1 == null) {
            lfenum1 = new ArrayList<>();
        }
        lfenum1.add(addTo);
    }


    @Override
    public void addToLfenum2(Lfenum2Enum addTo) {
        if (lfenum2 == null) {
            lfenum2 = new ArrayList<>();
        }
        lfenum2.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(lfnint8Min, lfnint8Max, lfnint16Min, lfnint16Max, lfnint32Min, lfnint32Max, lfnint64Min, lfnint64Max, lfnuint8Max, lfnuint16Max, lfnuint32Max, lfuint64Max, lfstr, lfstr1, lfbool1, lfbool2, lfbool3, lfdecimal1, lfdecimal2, lfdecimal3, lfdecimal4, lfdecimal6, lfenum, lfbits, lfbinary, lfref1, lfref2, lfempty, lfunion1, lfunion2, lfunion4, lfunion5, lfunion7, lfunion8, lfunion9, lfunion10, lfunion11, lfunion12, lfunion13, lfunion14, identityref1, lfenum1, lfenum2, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont1) {
            DefaultCont1 other = (DefaultCont1) obj;
            return
                Objects.deepEquals(lfnint8Min, other.lfnint8Min) &&
                Objects.deepEquals(lfnint8Max, other.lfnint8Max) &&
                Objects.deepEquals(lfnint16Min, other.lfnint16Min) &&
                Objects.deepEquals(lfnint16Max, other.lfnint16Max) &&
                Objects.deepEquals(lfnint32Min, other.lfnint32Min) &&
                Objects.deepEquals(lfnint32Max, other.lfnint32Max) &&
                Objects.deepEquals(lfnint64Min, other.lfnint64Min) &&
                Objects.deepEquals(lfnint64Max, other.lfnint64Max) &&
                Objects.deepEquals(lfnuint8Max, other.lfnuint8Max) &&
                Objects.deepEquals(lfnuint16Max, other.lfnuint16Max) &&
                Objects.deepEquals(lfnuint32Max, other.lfnuint32Max) &&
                Objects.deepEquals(lfuint64Max, other.lfuint64Max) &&
                Objects.deepEquals(lfstr, other.lfstr) &&
                Objects.deepEquals(lfstr1, other.lfstr1) &&
                Objects.deepEquals(lfbool1, other.lfbool1) &&
                Objects.deepEquals(lfbool2, other.lfbool2) &&
                Objects.deepEquals(lfbool3, other.lfbool3) &&
                Objects.deepEquals(lfdecimal1, other.lfdecimal1) &&
                Objects.deepEquals(lfdecimal2, other.lfdecimal2) &&
                Objects.deepEquals(lfdecimal3, other.lfdecimal3) &&
                Objects.deepEquals(lfdecimal4, other.lfdecimal4) &&
                Objects.deepEquals(lfdecimal6, other.lfdecimal6) &&
                Objects.deepEquals(lfenum, other.lfenum) &&
                Objects.deepEquals(lfbits, other.lfbits) &&
                Objects.deepEquals(lfbinary, other.lfbinary) &&
                Objects.deepEquals(lfref1, other.lfref1) &&
                Objects.deepEquals(lfref2, other.lfref2) &&
                Objects.deepEquals(lfempty, other.lfempty) &&
                Objects.deepEquals(lfunion1, other.lfunion1) &&
                Objects.deepEquals(lfunion2, other.lfunion2) &&
                Objects.deepEquals(lfunion4, other.lfunion4) &&
                Objects.deepEquals(lfunion5, other.lfunion5) &&
                Objects.deepEquals(lfunion7, other.lfunion7) &&
                Objects.deepEquals(lfunion8, other.lfunion8) &&
                Objects.deepEquals(lfunion9, other.lfunion9) &&
                Objects.deepEquals(lfunion10, other.lfunion10) &&
                Objects.deepEquals(lfunion11, other.lfunion11) &&
                Objects.deepEquals(lfunion12, other.lfunion12) &&
                Objects.deepEquals(lfunion13, other.lfunion13) &&
                Objects.deepEquals(lfunion14, other.lfunion14) &&
                Objects.deepEquals(identityref1, other.identityref1) &&
                Objects.deepEquals(lfenum1, other.lfenum1) &&
                Objects.deepEquals(lfenum2, other.lfenum2) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lfnint8Min=" + lfnint8Min)
            .add("lfnint8Max=" + lfnint8Max)
            .add("lfnint16Min=" + lfnint16Min)
            .add("lfnint16Max=" + lfnint16Max)
            .add("lfnint32Min=" + lfnint32Min)
            .add("lfnint32Max=" + lfnint32Max)
            .add("lfnint64Min=" + lfnint64Min)
            .add("lfnint64Max=" + lfnint64Max)
            .add("lfnuint8Max=" + lfnuint8Max)
            .add("lfnuint16Max=" + lfnuint16Max)
            .add("lfnuint32Max=" + lfnuint32Max)
            .add("lfuint64Max=" + lfuint64Max)
            .add("lfstr=" + lfstr)
            .add("lfstr1=" + lfstr1)
            .add("lfbool1=" + lfbool1)
            .add("lfbool2=" + lfbool2)
            .add("lfbool3=" + lfbool3)
            .add("lfdecimal1=" + lfdecimal1)
            .add("lfdecimal2=" + lfdecimal2)
            .add("lfdecimal3=" + lfdecimal3)
            .add("lfdecimal4=" + lfdecimal4)
            .add("lfdecimal6=" + lfdecimal6)
            .add("lfenum=" + lfenum)
            .add("lfbits=" + lfbits)
            .add("lfbinary=" + lfbinary)
            .add("lfref1=" + lfref1)
            .add("lfref2=" + lfref2)
            .add("lfempty=" + lfempty)
            .add("lfunion1=" + lfunion1)
            .add("lfunion2=" + lfunion2)
            .add("lfunion4=" + lfunion4)
            .add("lfunion5=" + lfunion5)
            .add("lfunion7=" + lfunion7)
            .add("lfunion8=" + lfunion8)
            .add("lfunion9=" + lfunion9)
            .add("lfunion10=" + lfunion10)
            .add("lfunion11=" + lfunion11)
            .add("lfunion12=" + lfunion12)
            .add("lfunion13=" + lfunion13)
            .add("lfunion14=" + lfunion14)
            .add("identityref1=" + identityref1)
            .add("lfenum1=" + lfenum1)
            .add("lfenum2=" + lfenum2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCont1.
     */
    public DefaultCont1() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}